package cn.zcltd.btg.httpsession.servlet.plugin;

import cn.zcltd.btg.httpsession.BTGSession;
import cn.zcltd.btg.httpsession.BTGSessionDao;
import cn.zcltd.btg.httpsession.BTGSessionIdGenerator;
import cn.zcltd.btg.httpsession.impl.BTGStandardSessionContext;
import cn.zcltd.btg.httpsession.kit.SessionKit;
import cn.zcltd.btg.httpsession.task.TaskBTGSessionTimeoutClean;
import com.jfinal.plugin.IPlugin;

import javax.servlet.ServletContext;
import java.util.Hashtable;

/**
 * BTG httpsession jfinal插件
 */
public class BTGSessionPlugin implements IPlugin {

    public BTGSessionPlugin() {

    }

    public BTGSessionPlugin(BTGSessionDao sessionDao) {
        SessionKit.setSessionDao(sessionDao);
    }

    @Override
    public boolean start() {
        TaskBTGSessionTimeoutClean.getInstance().start();
        return true;
    }

    @Override
    public boolean stop() {
        return true;
    }

    /**
     * 获取SessionContext
     *
     * @return SessionKit
     */
    public BTGStandardSessionContext getSessionContext() {
        return SessionKit.getSessionContext();
    }

    /**
     * 获取SessionContext
     *
     * @param servletContext servletContext
     * @return SessionKit
     */
    public BTGStandardSessionContext getSessionContext(ServletContext servletContext) {
        return SessionKit.getSessionContext(servletContext);
    }

    /**
     * 获取SessionContext
     *
     * @param servletContext servletContext
     * @param sessionDao     sessionDao
     * @return SessionKit
     */
    public BTGStandardSessionContext getSessionContext(ServletContext servletContext, BTGSessionDao sessionDao) {
        return SessionKit.getSessionContext(servletContext, sessionDao);
    }

    /**
     * 启用二级缓存
     */
    public void enableCache() {
        SessionKit.getSessionContext().enableCache();
    }

    /**
     * 禁用二级缓存
     */
    public void disableCache() {
        SessionKit.getSessionContext().disableCache();
    }

    /**
     * 添加一个session
     *
     * @param session BTGSession
     */
    public void addSession(BTGSession session) {
        SessionKit.getSessionContext().addSession(session);
    }

    /**
     * 根据session id移除一个session
     *
     * @param sessionId String
     */
    public void removeSession(String sessionId) {
        SessionKit.getSessionContext().removeSession(sessionId);
    }

    /**
     * 刷新一个session
     *
     * @param session BTGSession
     */
    public void refreshSession(BTGSession session) {
        SessionKit.getSessionContext().refreshSession(session);
    }

    /**
     * 根据session id获取一个session
     *
     * @param sessionId String
     * @return String
     */
    public BTGSession getSession(String sessionId) {
        return SessionKit.getSessionContext().getSession(sessionId);
    }

    /**
     * 获取一个新的session
     *
     * @return BTGSession
     */
    public BTGSession getNewSession() {
        return SessionKit.getSessionContext().getNewSession();
    }

    /**
     * 激活session
     *
     * @param session session
     */
    public void active(BTGSession session) {
        SessionKit.getSessionContext().active(session);
    }

    /**
     * 获取所有session
     *
     * @return Hashtable
     */
    public Hashtable<String, BTGSession> getSessions() {
        return SessionKit.getSessionContext().getSessions();
    }

    /**
     * 清理超时的session
     */
    public void clearTimeout() {
        SessionKit.getSessionContext().clearTimeout();
    }

    /**
     * 清空session容器
     */
    public void clear() {
        SessionKit.getSessionContext().clear();
    }

    /**
     * 获取session id名称key
     *
     * @return String
     */
    public String getSessionIdKey() {
        return SessionKit.getSessionContext().getSessionIdKey();
    }

    /**
     * 设置session id名称key
     *
     * @param sessionIdKey String
     */
    public void setSessionIdKey(String sessionIdKey) {
        SessionKit.getSessionContext().setSessionIdKey(sessionIdKey);
    }

    /**
     * 获取session超时时间
     *
     * @return int
     */
    public int getSessionTimeoutSeconds() {
        return SessionKit.getSessionContext().getSessionTimeoutSeconds();
    }

    /**
     * 设置session超时时间
     *
     * @param sessionTimeoutSeconds long
     */
    public void setSessionTimeoutSeconds(int sessionTimeoutSeconds) {
        SessionKit.getSessionContext().setSessionTimeoutSeconds(sessionTimeoutSeconds);
    }

    /**
     * 获取session cookie默认path
     *
     * @return String String
     */
    public String getSessionCookiePath() {
        return SessionKit.getSessionContext().getSessionCookiePath();
    }

    /**
     * 设置session cookie默认path
     *
     * @param sessionCookiePath session cookie默认path
     */
    public void setSessionCookiePath(String sessionCookiePath) {
        SessionKit.getSessionContext().setSessionCookiePath(sessionCookiePath);
    }

    /**
     * 获取是否禁用简单单点登录
     *
     * @return boolean boolean
     */
    public boolean isDisableSimpleSSO() {
        return SessionKit.getSessionContext().isDisableSimpleSSO();
    }

    /**
     * 设置是否禁用简单单点登录
     *
     * @param disableSimpleSSO disableSimpleSSO
     */
    public void setDisableSimpleSSO(boolean disableSimpleSSO) {
        SessionKit.getSessionContext().setDisableSimpleSSO(disableSimpleSSO);
    }

    /**
     * 获取过期session清理机制触发周期(毫秒)
     *
     * @return int
     */
    public int getMaxClearTimeoutSeconds() {
        return SessionKit.getSessionContext().getMaxClearTimeoutSeconds();
    }

    /**
     * 设置过期session清理机制触发周期(毫秒)
     *
     * @param maxClearTimeoutSeconds int
     */
    public void setMaxClearTimeoutSeconds(int maxClearTimeoutSeconds) {
        SessionKit.getSessionContext().setMaxClearTimeoutSeconds(maxClearTimeoutSeconds);
    }

    /**
     * 获取session最后访问时间同步更新机制触发周期(秒)
     *
     * @return 触发周期(秒)
     */
    public int getMaxUpdateLastActiveTimeSeconds() {
        return SessionKit.getSessionContext().getMaxUpdateLastActiveTimeSeconds();
    }

    /**
     * 设置session最后访问时间同步更新机制触发周期(秒)
     *
     * @param maxUpdateLastActiveTimeSeconds 触发周期(秒)
     */
    public void setMaxUpdateLastActiveTimeSeconds(int maxUpdateLastActiveTimeSeconds) {
        SessionKit.getSessionContext().setMaxUpdateLastActiveTimeSeconds(maxUpdateLastActiveTimeSeconds);
    }

    /**
     * 获取sessionId生成器
     *
     * @return BTGSessionIdGenerator
     */
    public BTGSessionIdGenerator getSessionIdGenerator() {
        return SessionKit.getSessionContext().getSessionIdGenerator();
    }

    /**
     * 设置sessionId生成器
     *
     * @param sessionIdGenerator BTGSessionIdGenerator
     */
    public void setSessionIdGenerator(BTGSessionIdGenerator sessionIdGenerator) {
        SessionKit.getSessionContext().setSessionIdGenerator(sessionIdGenerator);
    }

    /**
     * 获取session存储器
     *
     * @return BTGSessionDao
     */
    public BTGSessionDao getSessionDao() {
        return SessionKit.getSessionContext().getSessionDao();
    }

    /**
     * 设置session存储器
     *
     * @param sessionDao BTGSessionDao
     */
    public void setSessionDao(BTGSessionDao sessionDao) {
        SessionKit.getSessionContext().setSessionDao(sessionDao);
    }

    /**
     * 获取ServletContext
     *
     * @return ServletContext
     */
    public ServletContext getServletContext() {
        return SessionKit.getSessionContext().getServletContext();
    }

    /**
     * 设置ServletContext
     *
     * @param servletContext ServletContext
     */
    public void setServletContext(ServletContext servletContext) {
        SessionKit.getSessionContext().setServletContext(servletContext);
    }

    /**
     * 获取是否使用缓存
     *
     * @return 是否使用缓存
     */
    public boolean isUseCache() {
        return SessionKit.getSessionContext().isUseCache();
    }

    /**
     * 设置是否使用缓存
     *
     * @param useCache 是否使用缓存
     */
    public void setUseCache(boolean useCache) {
        SessionKit.getSessionContext().setUseCache(useCache);
    }
}