package cn.zcltd.btg.poi.ext;

/**
 * excel工具类
 */
public class ExcelUtil {

    /**
     * 将Excel表格中列号字母转成列索引，从0对应A开始
     *
     * @param column 列号
     * @return 列索引
     */
    public static int columnToIndex(String column) {
        column = column.trim().toUpperCase();
        if (!column.matches("[A-Z]+")) {
            try {
                throw new Exception("无效的列号");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        int index = 0;
        char[] chars = column.toUpperCase().toCharArray();
        for (int i = 0; i < chars.length; i++) {
            index += ((int) chars[i] - (int) 'A' + 1) * (int) Math.pow(26, chars.length - i - 1);
        }
        return --index;
    }

    /**
     * 将excel表格中列索引转成列号字母，从A对应0开始
     *
     * @param index 列索引
     * @return 列号
     */
    public static String indexToColumn(int index) {
        if (index < 0) {
            try {
                throw new Exception("无效的列索引");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        String column = "";
        do {
            if (column.length() > 0) {
                index--;
            }
            column = ((char) (index % 26 + (int) 'A')) + column;
            index = (index - index % 26) / 26;
        } while (index > 0);
        return column.toUpperCase();
    }
}