package cn.zcltd.btg.poi.ext.download;

import cn.zcltd.btg.poi.ext.download.bean.POITitle;
import cn.zcltd.btg.poi.ext.download.dataloader.POIDataLoader;
import cn.zcltd.btg.poi.ext.download.dataloader.POIDataLoaderJson;
import cn.zcltd.btg.poi.ext.download.typeenum.POIFileSaveType;
import cn.zcltd.btg.poi.ext.download.dataloader.POIDataLoaderMap;
import cn.zcltd.btg.poi.ext.download.typeenum.POIFileType;
import com.alibaba.fastjson.JSONObject;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 03版本excel下载
 */
public class POIDownloadXLS {

    private static String generate(String filePath, String fileName, POIFileType fileType, List<POITitle> titles, List datas, POIDataLoader POIDataLoader, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return POIDownload.generate(filePath, fileName, fileType, titles, datas, POIDataLoader, autoWidth, fileOnExists);
    }

    public static String generate(String filePath, String fileName, List<POITitle> titles, POIFileSaveType fileOnExists) throws IOException {
        return generate(filePath, fileName, POIFileType.XLS, titles, null, null, true, fileOnExists);
    }

    public static String generate(String filePath, List<POITitle> titles, POIFileSaveType fileOnExists) throws IOException {
        return generate(filePath, null, titles, fileOnExists);
    }

    public static String generateFromJson(String filePath, String fileName, List<POITitle> titles, List<JSONObject> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generate(filePath, fileName, POIFileType.XLS, titles, datas, new POIDataLoaderJson(), autoWidth, fileOnExists);
    }

    public static String generateFromJson(String filePath, String fileName, List<JSONObject> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generateFromJson(filePath, fileName, null, datas, autoWidth, fileOnExists);
    }

    public static String generateFromJson(String filePath, List<POITitle> titles, List<JSONObject> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generateFromJson(filePath, null, titles, datas, autoWidth, fileOnExists);
    }

    public static String generateFromJson(String filePath, List<JSONObject> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generateFromJson(filePath, null, null, datas, autoWidth, fileOnExists);
    }

    public static String generateFromMap(String filePath, String fileName, List<POITitle> titles, List<Map<String, Object>> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generate(filePath, fileName, POIFileType.XLS, titles, datas, new POIDataLoaderMap(), autoWidth, fileOnExists);
    }

    public static String generateFromMap(String filePath, String fileName, List<Map<String, Object>> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generateFromMap(filePath, fileName, null, datas, autoWidth, fileOnExists);
    }

    public static String generateFromMap(String filePath, List<POITitle> titles, List<Map<String, Object>> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generateFromMap(filePath, null, titles, datas, autoWidth, fileOnExists);
    }

    public static String generateFromMap(String filePath, List<Map<String, Object>> datas, boolean autoWidth, POIFileSaveType fileOnExists) throws IOException {
        return generateFromMap(filePath, null, null, datas, autoWidth, fileOnExists);
    }

    /*
        rename
     */
    public static String generate(String filePath, String fileName, List<POITitle> titles) throws IOException {
        return generate(filePath, fileName, POIFileType.XLS, titles, null, null, true, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generate(String filePath, List<POITitle> titles) throws IOException {
        return generate(filePath, null, titles, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromJson(String filePath, String fileName, List<POITitle> titles, List<JSONObject> datas, boolean autoWidth) throws IOException {
        return generate(filePath, fileName, POIFileType.XLS, titles, datas, new POIDataLoaderJson(), autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromJson(String filePath, String fileName, List<JSONObject> datas, boolean autoWidth) throws IOException {
        return generateFromJson(filePath, fileName, null, datas, autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromJson(String filePath, List<POITitle> titles, List<JSONObject> datas, boolean autoWidth) throws IOException {
        return generateFromJson(filePath, null, titles, datas, autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromJson(String filePath, List<JSONObject> datas, boolean autoWidth) throws IOException {
        return generateFromJson(filePath, null, null, datas, autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromMap(String filePath, String fileName, List<POITitle> titles, List<Map<String, Object>> datas, boolean autoWidth) throws IOException {
        return generate(filePath, fileName, POIFileType.XLS, titles, datas, new POIDataLoaderMap(), autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromMap(String filePath, String fileName, List<Map<String, Object>> datas, boolean autoWidth) throws IOException {
        return generateFromMap(filePath, fileName, null, datas, autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromMap(String filePath, List<POITitle> titles, List<Map<String, Object>> datas, boolean autoWidth) throws IOException {
        return generateFromMap(filePath, null, titles, datas, autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }

    public static String generateFromMap(String filePath, List<Map<String, Object>> datas, boolean autoWidth) throws IOException {
        return generateFromMap(filePath, null, null, datas, autoWidth, POIFileSaveType.RENAME_ON_EXISTS);
    }
}