package cn.zcltd.btg.poi.ext.download.celltheme;

import cn.zcltd.btg.poi.ext.download.style.POIStyleUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

/**
 * 单元格样式：默认主题
 */
public class POICellThemeDefault implements POICellTheme {

    @Override
    public CellStyle theme(Workbook workbook) {
        // 创建单元格样式
        CellStyle cellStyle = workbook.createCellStyle();

        cellStyle.setWrapText(true); //自动换行

        // 字体
        cellStyle.setFont(POIStyleUtil.createFontDefault(workbook));

        return cellStyle;
    }
}
