package cn.zcltd.btg.poi.ext.download.celltheme;

import cn.zcltd.btg.poi.ext.download.style.POIStyleUtil;
import org.apache.poi.ss.usermodel.*;

/**
 * 单元格样式：必填
 */
public class POICellThemeRequiredTitle implements POICellTheme {

    @Override
    public CellStyle theme(Workbook workbook) {
        // 创建单元格样式
        CellStyle cellStyle = workbook.createCellStyle();

        cellStyle.setWrapText(true); //自动换行
        cellStyle.setAlignment(HorizontalAlignment.CENTER);//居中
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);//垂直居中

        //边框
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);

        // 字体
        cellStyle.setFont(POIStyleUtil.createFontDefaultRed(workbook));

        return cellStyle;
    }
}