package cn.zcltd.btg.poi.ext.download.style;

import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

/**
 * POI excel处理格式
 */
public class POIStyleUtil {

    /**
     * 创建字体（默认）
     *
     * @param workbook workbook
     * @return Font
     */
    public static Font createFontDefault(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontName("宋体");
        font.setFontHeightInPoints((short) 10);
        return font;
    }

    /**
     * 创建字体（默认+红色字体）
     *
     * @param workbook workbook
     * @return Font
     */
    public static Font createFontDefaultRed(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontName("宋体");
        font.setFontHeightInPoints((short) 10);
        font.setColor(Font.COLOR_RED);
        return font;
    }

    /**
     * 自动宽度
     *
     * @param sheet     sheet
     * @param maxColumn maxColumn
     */
    public static void autoSizeColumn(Sheet sheet, int maxColumn) {
        for (int i = 0; i < maxColumn; i++) {
            sheet.autoSizeColumn(i);
        }
    }
}