package cn.zcltd.btg.poi.ext.download.typeenum;

/**
 * 文件类型
 */
public enum POIFileType {
    XLS(1, "xls", 65536), XLSX(2, "xlsx", 1048576);

    private POIFileType(int value, String suf, int maxRow) {
        this.value = value;
        this.suf = suf;
        this.maxRow = maxRow;
    }

    private int value; //值
    private String suf; //后缀
    private int maxRow; //单sheet最大行

    public int getValue() {
        return value;
    }

    public String getSuf() {
        return suf;
    }

    public int getMaxRow() {
        return maxRow;
    }
}