package cn.zcltd.btg.poi.ext.iterator;

import cn.zcltd.btg.poi.ext.exception.UnsupportedVersionException;
import cn.zcltd.btg.poi.ext.POIReadUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

import java.util.List;

/**
 * POI Adapter
 */
public class POIIterator {

    /**
     * POI 工作表适配器
     *
     * @param sheets  工作表List
     * @param adapter 适配器
     */
    public static void adapterSheet(List<Sheet> sheets, POISheetIterator adapter) {
        for (Sheet sheet : sheets) {
            adapter.iterator(sheet);
        }
    }

    /**
     * POI 工作表适配器
     *
     * @param filePath 文件路径
     * @param adapter  适配器
     */
    public static void adapterSheet(String filePath, POISheetIterator adapter) throws UnsupportedVersionException {
        List<Sheet> sheets = POIReadUtil.getSheets(POIReadUtil.getWorkbook(filePath), 0);
        adapterSheet(sheets, adapter);
    }

    /**
     * POI 行适配器
     *
     * @param rows    行List
     * @param adapter 适配器
     */
    public static void adapterRow(List<Row> rows, POIRowIterator adapter) {
        for (Row row : rows) {
            adapter.iterator(row);
        }
    }

    /**
     * POI 单元格适配器
     *
     * @param cells   单元格List
     * @param adapter 适配器
     */
    public static void adapterCell(List<Cell> cells, POICellIterator adapter) {
        for (Cell cell : cells) {
            adapter.iterator(cell);
        }
    }
}
