package cn.zcltd.btg.session;

import java.util.Enumeration;

/**
 * btg session
 */
public interface BTGSession {

    /**
     * session创建时间
     *
     * @return long
     */
    long getCreationTime();

    /**
     * 获取session id
     *
     * @return String
     */
    String getId();

    /**
     * 获取最后激活时间
     *
     * @return long
     */
    long getLastAccessedTime();

    /**
     * 设置session最大空闲时间(session过期时间)
     *
     * @param maxInactiveInterval int
     */
    void setMaxInactiveInterval(int maxInactiveInterval);

    /**
     * 获取session最大空间时间(session过期时间)
     *
     * @return int
     */
    int getMaxInactiveInterval();

    /**
     * 获取session上下文
     *
     * @return BTGSessionContext
     */
    BTGSessionContext getSessionContext();

    /**
     * 根据key获取session的value值
     *
     * @param name String
     * @return Object
     */
    Object getAttribute(String name);

    /**
     * 获取session所有参数的key
     *
     * @return Enumeration
     */
    Enumeration<String> getAttributeNames();

    /**
     * 设置session参数值
     *
     * @param name  String
     * @param value Object
     */
    void setAttribute(String name, Object value);

    /**
     * 根据参数名清理session保存的参数
     *
     * @param name name
     */
    void removeAttribute(String name);

    /**
     * 使session失效
     */
    void invalidate();

    /**
     * 是否新创建的session
     *
     * @return boolean
     */
    boolean isNew();

    /**
     * 设置最后激活时间
     *
     * @param lastAccessedTime long
     */
    void setLastAccessedTime(long lastAccessedTime);

    /**
     * 是否失效
     *
     * @return boolean
     */
    public boolean isInvalidate();

    /**
     * 使session处于活跃状态
     */
    public void active();

    /**
     * 克隆
     *
     * @return 克隆的对象
     */
    public BTGSession cloneMe();

    /**
     * 添加属性不进行session同步更新
     *
     * @param key 参数名
     * @param obj 参数值
     */
    public void addAttributeNotRefresh(String key, Object obj);

    /**
     * 获取session最后访问时间最后同步更新时间
     *
     * @return session最后访问时间最后同步更新时间
     */
    public long getLastUpdateMillis();

    /**
     * 设置session最后访问时间最后同步更新时间
     *
     * @param lastUpdateMillis session最后访问时间最后同步更新时间
     */
    public void setLastUpdateMillis(long lastUpdateMillis);
}