package cn.zcltd.btg.session.kit;

import cn.zcltd.btg.session.BTGSession;
import cn.zcltd.btg.session.BTGSessionDao;
import cn.zcltd.btg.session.BTGSessionIdGenerator;
import cn.zcltd.btg.session.impl.BTGStandardSessionContext;

import java.util.Hashtable;

/**
 * session操作工具类，提供BTGStandardSessionContext的静态访问接口
 */
public class SessionKit {

    /**
     * 启用二级缓存
     */
    public static void enableCache() {
        BTGStandardSessionContext.getSessionContext().enableCache();
    }

    /**
     * 禁用二级缓存
     */
    public static void disableCache() {
        BTGStandardSessionContext.getSessionContext().disableCache();
    }

    /**
     * 获取SessionContext
     *
     * @return BTGStandardSessionContext
     */
    public static BTGStandardSessionContext getSessionContext() {
        return BTGStandardSessionContext.getSessionContext();
    }

    /**
     * 获取SessionContext
     *
     * @param sessionDao sessionDao
     * @return BTGStandardSessionContext
     */
    public static BTGStandardSessionContext getSessionContext(BTGSessionDao sessionDao) {
        return BTGStandardSessionContext.getSessionContext(sessionDao);
    }

    /**
     * 添加一个session
     *
     * @param session BTGSession
     */
    public static void addSession(BTGSession session) {
        BTGStandardSessionContext.getSessionContext().addSession(session);
    }

    /**
     * 根据session id移除一个session
     *
     * @param sessionId String
     */
    public static void removeSession(String sessionId) {
        BTGStandardSessionContext.getSessionContext().removeSession(sessionId);
    }

    /**
     * 根据session id获取一个session
     *
     * @param sessionId String
     * @return String
     */
    public static BTGSession getSession(String sessionId) {
        return BTGStandardSessionContext.getSessionContext().getSession(sessionId);
    }

    /**
     * 获取一个新的session
     *
     * @return BTGSession
     */
    public static BTGSession getNewSession() {
        return BTGStandardSessionContext.getSessionContext().getNewSession();
    }

    /**
     * 刷新一个session
     *
     * @param session BTGSession
     */
    public static void refreshSession(BTGSession session) {
        BTGStandardSessionContext.getSessionContext().refreshSession(session);
    }

    /**
     * 激活session
     *
     * @param session session
     */
    public static void active(BTGSession session) {
        BTGStandardSessionContext.getSessionContext().active(session);
    }

    /**
     * 获取所有session
     *
     * @return Hashtable
     */
    public static Hashtable<String, BTGSession> getSessions() {
        return BTGStandardSessionContext.getSessionContext().getSessions();
    }

    /**
     * 清理超时的session
     */
    public static void clearTimeout() {
        BTGStandardSessionContext.getSessionContext().clearTimeout();
    }

    /**
     * session清理算法机制：
     * 1、设置清理周期，默认为30分钟；
     * 2、非绝对清理，当触发了addSession、removeSession、refreshSession、getSession、getNewSession、active时触发清理机制；
     * 3、通过调用clearTimeout手动清理；
     */
    public static void checkSessionTimeout() {
        BTGStandardSessionContext.getSessionContext().checkSessionTimeout();
    }

    /**
     * 清空session容器
     */
    public static void clear() {
        BTGStandardSessionContext.getSessionContext().clear();
    }

    /**
     * 获取session id名称key
     *
     * @return String
     */
    public static String getSessionIdKey() {
        return BTGStandardSessionContext.getSessionContext().getSessionIdKey();
    }

    /**
     * 设置session id名称key
     *
     * @param sessionIdKey String
     */
    public static void setSessionIdKey(String sessionIdKey) {
        BTGStandardSessionContext.getSessionContext().setSessionIdKey(sessionIdKey);
    }

    /**
     * 获取session超时时间
     *
     * @return int
     */
    public static int getSessionTimeoutMillis() {
        return BTGStandardSessionContext.getSessionContext().getSessionTimeoutMillis();
    }

    /**
     * 设置session超时时间
     *
     * @param sessionTimeout long
     */
    public static void setSessionTimeoutMillis(int sessionTimeout) {
        BTGStandardSessionContext.getSessionContext().setSessionTimeoutMillis(sessionTimeout);
    }

    /**
     * 获取过期session清理机制触发周期(毫秒)
     *
     * @return int
     */
    public static int getMaxClearTimeoutMillis() {
        return BTGStandardSessionContext.getSessionContext().getMaxClearTimeoutMillis();
    }

    /**
     * 设置过期session清理机制触发周期(毫秒)
     *
     * @param maxClearTimeoutMillis int
     */
    public static void setMaxClearTimeoutMillis(int maxClearTimeoutMillis) {
        BTGStandardSessionContext.getSessionContext().setMaxClearTimeoutMillis(maxClearTimeoutMillis);
    }

    /**
     * 获取sessionId生成器
     *
     * @return BTGSessionIdGenerator
     */
    public static BTGSessionIdGenerator getSessionIdGenerator() {
        return BTGStandardSessionContext.getSessionContext().getSessionIdGenerator();
    }

    /**
     * 设置sessionId生成器
     *
     * @param sessionIdGenerator BTGSessionIdGenerator
     */
    public static void setSessionIdGenerator(BTGSessionIdGenerator sessionIdGenerator) {
        BTGStandardSessionContext.getSessionContext().setSessionIdGenerator(sessionIdGenerator);
    }

    /**
     * 获取session存储器
     *
     * @return BTGSessionDao
     */
    public static BTGSessionDao getSessionDao() {
        return BTGStandardSessionContext.getSessionContext().getSessionDao();
    }

    /**
     * 设置session存储器
     *
     * @param sessionDao BTGSessionDao
     */
    public static void setSessionDao(BTGSessionDao sessionDao) {
        BTGStandardSessionContext.getSessionContext().setSessionDao(sessionDao);
    }
}