package cn.zcltd.btg.set.token;

import java.text.SimpleDateFormat;

/**
 * Main
 */
public class MainToken {

    public static void main(String[] args) {
        try {
            boolean hasH = false; //是否包含"-h"
            boolean hasT = false; //是否包含"-t"
            boolean hasK = false; //是否包含"-k"

            /*
                参数解析
             */
            TokenConfig tokenConfig = new TokenConfig();
            for (String arg : args) {
                if (arg.startsWith("-h")) {
                    hasH = true;
                }
                if (arg.startsWith("-t")) {
                    hasT = true;
                    try {
                        String tvalue = arg.substring(2);
                        if ("".equals(tvalue)) {
                            System.out.println("-t选项无效");
                            return;
                        }
                        tokenConfig.setTimeoutDate(new SimpleDateFormat("yyyyMMddHHmmss").parse(tvalue));
                    } catch (Exception e) {
                        System.out.println("-t选项无效");
                        return;
                    }
                }
                if (arg.startsWith("-ip")) {
                    try {
                        String ipvalue = arg.substring(3);
                        String[] ipRegexs = ipvalue.split(",");
                        for (String ipRegex : ipRegexs) {
                            tokenConfig.getIpRegex().add(ipRegex);
                        }
                    } catch (Exception e) {
                        System.out.println("-ip选项无效");
                        return;
                    }
                }
                if (arg.startsWith("-u")) {
                    try {
                        String uvalue = arg.substring(2);
                        String[] userRegexs = uvalue.split(",");
                        for (String userRegex : userRegexs) {
                            tokenConfig.getUserRegex().add(userRegex);
                        }
                    } catch (Exception e) {
                        System.out.println("-u选项无效");
                        return;
                    }
                }
                if (arg.startsWith("-k")) {
                    hasK = true;
                    try {
                        String kvalue = arg.substring(2);
                        if ("".equals(kvalue)) {
                            System.out.println("-k选项无效");
                            return;
                        }
                        tokenConfig.setKey(kvalue);
                    } catch (Exception e) {
                        System.out.println("-k选项无效");
                        return;
                    }
                }
            }

            if (!hasH && !hasK) {
                System.out.println("缺失-k选项");
                return;
            }

            if (!hasH && !hasT) {
                System.out.println("缺失-t选项");
                return;
            }

            /*
                帮助支持
             */
            if (hasH) {
                StringBuilder helpSb = new StringBuilder();
                helpSb.append("  -h    帮助信息\r\n");
                helpSb.append("  -t    token失效时间，格式为yyyyMMddHHmmss，默认为从生成时间开始计算20分钟后失效\r\n");
                helpSb.append("  -ip   ip地址白名单正则表达式，多个以\",\"连接，默认为不限制\r\n");
                helpSb.append("  -u    登录用户名白名单正则表达式，多个以\",\"连接，默认为不限制\r\n");
                helpSb.append("  -k    加密key，即应用配置的验证token的key\r\n");
                System.out.println(helpSb.toString());
                return;
            }

            /*
                根据配置生成token
             */
            System.out.println(Generater.gen(tokenConfig));
        } catch (Exception e) {
            System.out.println("生成token出错");
            e.printStackTrace();
        }
    }
}