package cn.zcltd.btg.set.util;

/**
 * util:String
 */
public class StringUtil {

    /**
     * 验证字符串是否为null或空值
     *
     * @param str 需要验证的字符串
     * @return 为null或空值返回true，否则返回false
     */
    public static boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    /**
     * 验证字符串是否为非null或空值
     *
     * @param str 需要验证的字符串
     * @return 不为null或空值返回true，否则返回false
     */
    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    /**
     * 获取指定个数tab(4个空格我一个tab)
     *
     * @param num tab个数
     * @return String
     */
    public static String getTab(int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; i++) {
            sb.append("    ");
        }
        return sb.toString();
    }
}