package cn.zcltd.btg.set;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 为类提供获取各种基本类型的功能
 * 为类提供获取各种基本类型若值为null返回默认值的功能
 */
public interface ParamGetter {

    /**
     * 根据key获取String类型的值
     *
     * @param key key
     * @return 值
     */
    public String getString(String key);

    /**
     * 根据key获取String类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public String getString(String key, String defaultValue);

    /**
     * 根据key获取Boolean类型的值
     *
     * @param key key
     * @return 值
     */
    public Boolean getBoolean(String key);

    /**
     * 根据key获取Boolean类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Boolean getBoolean(String key, Boolean defaultValue);

    /**
     * 根据key获取Number类型的值
     *
     * @param key key
     * @return 值
     */
    public Number getNumber(String key);

    /**
     * 根据key获取Number类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Number getNumber(String key, Number defaultValue);

    /**
     * 根据key获取Integer类型的值
     *
     * @param key key
     * @return 值
     */
    public Integer getInteger(String key);

    /**
     * 根据key获取Integer类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Integer getInteger(String key, Integer defaultValue);

    /**
     * 根据key获取Long类型的值
     *
     * @param key key
     * @return 值
     */
    public Long getLong(String key);

    /**
     * 根据key获取Long类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Long getLong(String key, Long defaultValue);

    /**
     * 根据key获取Float类型的值
     *
     * @param key key
     * @return 值
     */
    public Float getFloat(String key);

    /**
     * 根据key获取Float类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Float getFloat(String key, Float defaultValue);

    /**
     * 根据key获取Double类型的值
     *
     * @param key key
     * @return 值
     */
    public Double getDouble(String key);

    /**
     * 根据key获取Double类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Double getDouble(String key, Double defaultValue);

    /**
     * 根据key获取BigDecimal类型的值
     *
     * @param key key
     * @return 值
     */
    public BigDecimal getBigDecimal(String key);

    /**
     * 根据key获取BigDecimal类型的值，若为null返回默认值
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue);

    /**
     * 根据key获取Date类型的值
     * 根据参数类型、值类型、长度自动匹配对应的格式：
     * 若为Boolean类型，放弃转换，返回null
     * 若为Number类型将去掉小数后的值作为Date.getTime值转换为date；
     * 若为String类型：
     * 当Param对象指定了datePattern则直接使用，否则
     * 若length为10，对应“yyyy-MM-dd”
     * 若length为8，对应“HH:mm:ss”
     * 若length为19，对应“yyyy-MM-dd HH:mm:ss”
     * 若length为17，对应“yyyyMMddHHmmssSSS”
     * 若为其他，无法识别，返回null
     *
     * @param key key
     * @return 值
     */
    public Date getDate(String key);

    /**
     * 根据key获取Date类型的值，若为null返回默认值
     * 根据参数类型、值类型、长度自动匹配对应的格式：
     * 若为Boolean类型，放弃转换，返回defaultValue
     * 若为Number类型将去掉小数后的值作为Date.getTime值转换为date；
     * 若为String类型：
     * 当Param对象指定了datePattern则直接使用，否则
     * 若length为10，对应“yyyy-MM-dd”
     * 若length为8，对应“HH:mm:ss”
     * 若length为19，对应“yyyy-MM-dd HH:mm:ss”
     * 若length为17，对应“yyyyMMddHHmmssSSS”
     * 若为其他，无法识别，返回defaultValue
     *
     * @param key          key
     * @param defaultValue defaultValue
     * @return 值
     */
    public Date getDate(String key, Date defaultValue);

    /**
     * 根据key和指定格式化参数获取Date类型的值
     *
     * @param key         key
     * @param datePattern 格式化参数
     * @return 值
     */
    public Date getDate(String key, String datePattern);

    /**
     * 根据key和指定格式化参数获取Date类型的值，若为null返回默认值
     *
     * @param key          key
     * @param datePattern  格式化参数
     * @param defaultValue defaultValue
     * @return 值
     */
    public Date getDate(String key, String datePattern, Date defaultValue);

}