package cn.zcltd.btg.set.core;

import cn.zcltd.btg.set.adaptor.EventAdapter;
import cn.zcltd.btg.set.sourcemanager.SourceManager;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 静态访问入口
 */
public class BtgSet {

    private static ConfigManager configManager = ConfigManager.getInstance();

    /**
     * 私有无参构造方法，禁止new
     */
    private BtgSet() {

    }

    public static boolean isDevModel() {
        return configManager.isDevModel();
    }

    public static void setDevModel(boolean devModel) {
        configManager.setDevModel(devModel);
    }

    public static Map<String, SourceManager> getSourceManagerMap() {
        return configManager.getSourceManagerMap();
    }

    public static void setSourceManagerMap(Map<String, SourceManager> sourceManagerMap) {
        configManager.setSourceManagerMap(sourceManagerMap);
    }

    public static SourceManager getSourceManager(String name) {
        return configManager.getSourceManager(name);
    }

    public static void addSourceManager(SourceManager sourceManager) {
        configManager.addSourceManager(sourceManager);
    }

    public static SourceManager getThisSourceManager() {
        return configManager.getThisSourceManager();
    }

    public static void setThisSourceManager(SourceManager thisSourceManager) {
        configManager.setThisSourceManager(thisSourceManager);
    }

    public static Config getThisConfig() {
        return configManager.getThisConfig();
    }

    public static void setThisConfig(Config thisConfig) {
        configManager.setThisConfig(thisConfig);
    }

    public static List<EventAdapter> getEventAdapters() {
        return configManager.getEventAdapters();
    }

    public static void setEventAdapters(List<EventAdapter> eventAdapters) {
        configManager.setEventAdapters(eventAdapters);
    }

    public static void addEventAdapter(EventAdapter eventAdapter) {
        configManager.addEventAdapter(eventAdapter);
    }

    public static void init(boolean devModel, SourceManager defaultSourceManager, String defaultConfigId) {
        configManager.init(devModel, defaultSourceManager, defaultConfigId);
    }

    public static SourceManager useSourceManager() {
        return configManager.useSourceManager();
    }

    public static SourceManager useSourceManager(String name) {
        return configManager.useSourceManager(name);
    }

    public static void applySourceManager(String name) {
        configManager.applySourceManager(name);
    }

    public static Config use() {
        return configManager.use();
    }

    public static Config use(String configId) {
        return configManager.use(configId);
    }

    public static void apply(String configId) {
        configManager.apply(configId);
    }

    public static void merge(Config config) {
        configManager.merge(config);
    }

    public static void mergeAll(Config config) {
        configManager.mergeAll(config);
    }

    public static Config copyTo(String configId, String targetId) {
        return configManager.copyTo(configId, targetId);
    }

    public static void syn(SourceManager sourceManager, SourceManager targetSourceManager) {
        configManager.syn(sourceManager, targetSourceManager);
    }

    public static void syn(SourceManager targetSourceManager) {
        configManager.syn(targetSourceManager);
    }

    public static String getString(String key) {
        return configManager.getString(key);
    }

    public static String getString(String key, String defaultValue) {
        return configManager.getString(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return configManager.getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return configManager.getBoolean(key, defaultValue);
    }

    public static Number getNumber(String key) {
        return configManager.getNumber(key);
    }

    public static Number getNumber(String key, Number defaultValue) {
        return configManager.getNumber(key, defaultValue);
    }

    public static Integer getInteger(String key) {
        return configManager.getInteger(key);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        return configManager.getInteger(key, defaultValue);
    }

    public static Long getLong(String key) {
        return configManager.getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return configManager.getLong(key, defaultValue);
    }

    public static Float getFloat(String key) {
        return configManager.getFloat(key);
    }

    public static Float getFloat(String key, Float defaultValue) {
        return configManager.getFloat(key, defaultValue);
    }

    public static Double getDouble(String key) {
        return configManager.getDouble(key);
    }

    public static Double getDouble(String key, Double defaultValue) {
        return configManager.getDouble(key, defaultValue);
    }

    public static BigDecimal getBigDecimal(String key) {
        return configManager.getBigDecimal(key);
    }

    public static BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return configManager.getBigDecimal(key, defaultValue);
    }

    public static Date getDate(String key) {
        return configManager.getDate(key);
    }

    public static Date getDate(String key, Date defaultValue) {
        return configManager.getDate(key, defaultValue);
    }

    public static Date getDate(String key, String datePattern) {
        return configManager.getDate(key, datePattern);
    }

    public static Date getDate(String key, String datePattern, Date defaultValue) {
        return configManager.getDate(key, datePattern, defaultValue);
    }
}