package cn.zcltd.btg.set.sourcemanager.db.dialect;

import cn.zcltd.btg.set.util.DbUtil;

import java.sql.Connection;

/**
 * MySQL方言实现
 */
public class MySQLDialect extends Dialect {

    @Override
    public boolean tableIsExists(Connection conn, String tableName) {
        return super.tableIsExists(conn, tableName); //fixme:可以不采用jdbc的方式，直接查字典表获取是否存在，待优化
    }

    @Override
    public void createTableConfig(Connection conn, String tableName) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("create table ");
        sqlSb.append(tableName);
        sqlSb.append("(");
        sqlSb.append("config_id varchar(64),");
        sqlSb.append("config_name varchar(256),");
        sqlSb.append("config_desc varchar(1024),");
        sqlSb.append("primary key (config_id)");
        sqlSb.append(")");
        DbUtil.executeUpdate(conn, sqlSb.toString());
        log.debug("create table for param:" + tableName);
    }

    @Override
    public void createTableModule(Connection conn, String tableName) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("create table ");
        sqlSb.append(tableName);
        sqlSb.append("(");
        sqlSb.append("config_id varchar(64),");
        sqlSb.append("module_id varchar(64),");
        sqlSb.append("module_name varchar(256),");
        sqlSb.append("module_desc varchar(1024),");
        sqlSb.append("primary key (config_id,module_id)");
        sqlSb.append(")");
        DbUtil.executeUpdate(conn, sqlSb.toString());
        log.debug("create table for module:" + tableName);
    }

    @Override
    public void createTableParam(Connection conn, String tableName) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("create table ");
        sqlSb.append(tableName);
        sqlSb.append("(");
        sqlSb.append("config_id varchar(64),");
        sqlSb.append("module_id varchar(64),");
        sqlSb.append("param_id varchar(64),");
        sqlSb.append("param_source varchar(16),");
        sqlSb.append("param_type varchar(64),");
        sqlSb.append("param_date_pattern varchar(64),");
        sqlSb.append("param_name varchar(256),");
        sqlSb.append("param_value varchar(512),");
        sqlSb.append("param_desc varchar(1024),");
        sqlSb.append("param_remark varchar(1024),");
        sqlSb.append("primary key (config_id, module_id, param_id)");
        sqlSb.append(")");
        DbUtil.executeUpdate(conn, sqlSb.toString());
        log.debug("create table for param:" + tableName);
    }
}