package cn.zcltd.btg.set.adaptor;

import cn.zcltd.btg.set.core.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 提供配置事件监听功能
 * 若需接受配置监听回调，继承该类重写响应方法即可
 */
public class EventAdapter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 当当前配置加载时触发
     *
     * @param configOld 加载前config
     * @param configNew 加载后config
     */
    public void onThisConfigLoad(Config configOld, Config configNew) {
        log.debug("onThisConfigLoad: " + configOld.getId() + ">" + configNew.getId());
    }
}