package cn.zcltd.btg.set.token;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 配置
 */
public class TokenConfig {

    private Date timeoutDate; //token过期时间，默认为生成后20分钟后
    private List<String> ipRegex; //ip地址白名单正则表达式匹配，默认为所有ip
    private List<String> userRegex; //登录用户正则表达式匹配，默认为所有用户
    private String key; //生成token的key，即应用配置的key

    public TokenConfig() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(Calendar.DATE, 20);
        this.timeoutDate = new Date(c.getTimeInMillis());
        this.ipRegex = new ArrayList<>();
        this.userRegex = new ArrayList<>();
    }

    public Date getTimeoutDate() {
        return timeoutDate;
    }

    public void setTimeoutDate(Date timeoutDate) {
        this.timeoutDate = timeoutDate;
    }

    public List<String> getIpRegex() {
        return ipRegex;
    }

    public void setIpRegex(List<String> ipRegex) {
        this.ipRegex = ipRegex;
    }

    public List<String> getUserRegex() {
        return userRegex;
    }

    public void setUserRegex(List<String> userRegex) {
        this.userRegex = userRegex;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String toString() {
        return "Config{" +
                "timeoutDate='" + new SimpleDateFormat("yyyyMMddHHmmss").format(timeoutDate) + '\'' +
                ", ipRegex=" + ipRegex +
                ", userRegex=" + userRegex +
                ", key='" + key + '\'' +
                '}';
    }
}