package cn.zcltd.btg.set;

/**
 * 参数类型
 */
public enum ParamType {
    Boolean("Boolean", "java.lang.Boolean"),
    String("String", "java.lang.String"),
    Integer("Integer", "java.lang.Integer"),
    Long("Long", "java.lang.Long"),
    Float("Float", "java.lang.Float"),
    Double("Double", "java.lang.Double"),
    BigDecimal("BigDecimal", "java.math.BigDecimal"),
    Date("Date", "java.util.Date");

    private String name; //类型名称
    private String pkgName; //类型包路径名称

    private ParamType(String name, String pkgName) {
        this.name = name;
        this.pkgName = pkgName;
    }

    @Override
    public java.lang.String toString() {
        return "ParamDataType{" +
                "name='" + name + '\'' +
                ", pkgName='" + pkgName + '\'' +
                '}';
    }

    public String getName() {
        return name;
    }

    public String getPkgName() {
        return pkgName;
    }
}