package com.btg.sql;

import com.btg.sql.util.SqlHandler;
import com.btg.sql.util.SqlHelp;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2016/12/29.
 */
public class SqlManager {

    private static SqlManager sqlManager = null;

    private String xmlPath = null;

    private boolean devMode = false;

    private SqlManager() {
    }

    private SqlManager(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    private SqlManager(String xmlPath, boolean devMode) {
        this.xmlPath = xmlPath;
        this.devMode = devMode;
    }

    public static SqlManager init(String xmlPath) {
        return init(xmlPath, false);
    }

    public static SqlManager init(String xmlPath, boolean devMode) {
        if (sqlManager == null) {
            synchronized (SqlManager.class) {
                if (sqlManager == null) {
                    sqlManager = new SqlManager(xmlPath, devMode);
                    SqlHandler.init();
                }
            }
        }
        return sqlManager;
    }

    public static SqlManager instance() {
        return sqlManager;
    }

    public SqlManager setDevMode(boolean devMode) {
        this.devMode = devMode;
        return init(this.xmlPath, this.devMode);
    }

    public boolean getDevMode() {
        return this.devMode;
    }


    public SqlManager setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
        return init(this.xmlPath);
    }

    public String getXmlPath() {
        return this.xmlPath;
    }


    /**
     * 根据传入参数取得原始（未处理过）sql
     *
     * @param sqlId   sqlId
     * @param paraMap paraMap
     * @return String
     */
    public String getSqlNative(String sqlId, Map<String, Object> paraMap) {
        return SqlHandler.getSqlNative(sqlId, paraMap);
    }

    /**
     * 根据传入参数取得原始（未处理过）sql
     *
     * @param sqlId sqlId
     * @return String
     */
    public String getSqlNative(String sqlId) {
        return getSqlNative(sqlId, null);
    }

    /**
     * 根据传入参数取得处理后的sql及数组
     *
     * @param sqlId   sqlId
     * @param paraMap paraMap
     * @return SqlHelp
     */
    public SqlHelp getSqlHandler(String sqlId, Map<String, Object> paraMap) {
        return SqlHandler.getSqlHandler(sqlId, paraMap);
    }

    public static void main(String[] arg) {
        String path = SqlManager.class.getResource("/").getPath() + "demo.xml";
        SqlManager.init(path);

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("get_root", "true");
        map.put("only_enable", "2");

        System.out.println(SqlManager.instance().getSqlNative("user.xxx", map));
    }
}