package cn.zcltd.btg.validq.validator;

import cn.zcltd.btg.validq.ValidationError;
import cn.zcltd.btg.validq.ValidatorContext;
import cn.zcltd.btg.validq.ValidatorHandler;

import java.util.Collection;
import java.util.Map;

/**
 * 验证对象必须为empty
 */
public class IsEmptyValidator extends ValidatorHandler<Object> {

    public IsEmptyValidator() {
    }

    public IsEmptyValidator(String field, String fieldName) {
        super(field, fieldName);
    }

    public IsEmptyValidator(String field, String fieldName, String errorMsg) {
        super(field, fieldName, errorMsg);
    }

    @Override
    public int index() {
        return 3;
    }

    @Override
    public boolean validate(ValidatorContext context, Object target) {
        if (null == target) {
            return true;
        }
        if (target instanceof Collection && ((Collection) target).size() == 0) {
            return true;
        }
        if (target instanceof Map && ((Map) target).size() == 0) {
            return true;
        }
        if (target instanceof Object[] && ((Object[]) target).length == 0) {
            return true;
        }
        if (target instanceof String && ((String) target).trim().length() == 0) {
            return true;
        }

        String errorMsg = getDefaultMsg("[%s]必须为空");
        errorMsg = context.replaceParams(errorMsg);

        ValidationError validationError = new ValidationError()
                .setValidator(this)
                .setField(this.getField())
                .setShortField(this.getShortField())
                .setFieldName(this.getFieldName())
                .setShortFieldName(this.getShortFieldName())
                .setErrorCode(this.getErrorCode())
                .setErrorMsg(errorMsg)
                .setErrorValue(target);
        context.addError(validationError);

        return false;
    }
}