package cn.zcltd.btg.validq.validator;

import cn.zcltd.btg.validq.ValidationError;
import cn.zcltd.btg.validq.ValidatorContext;
import cn.zcltd.btg.validq.ValidatorHandler;
import cn.zcltd.btg.validq.exception.ValidQException;

/**
 * 验证String长度必须在min到max之间
 */
public class StringLengthValidator extends ValidatorHandler<String> {

    private Integer min = 0;
    private Integer max = Integer.MAX_VALUE;

    public StringLengthValidator() {
    }

    public StringLengthValidator(String field, String fieldName) {
        super(field, fieldName);
    }

    public StringLengthValidator(String field, String fieldName, String errorMsg) {
        super(field, fieldName, errorMsg);
    }

    @Override
    public int index() {
        return 5;
    }

    @Override
    public boolean validate(ValidatorContext context, String target) {
        if (target == null || target.trim().length() == 0) {
            return true;
        }
        if (min <= 0) {
            throw new ValidQException("min greater than 0");
        }
        if (max <= 0) {
            throw new ValidQException("max greater than 0");
        }
        if (target.trim().length() >= min && target.trim().length() <= max) {
            return true;
        }

        String errorMsg = null;
        if (target.trim().length() < min) {
            errorMsg = getDefaultMsg(String.format("[%s]长度不能小于[%s]", "%s", min));
        }
        if (target.trim().length() > max) {
            errorMsg = getDefaultMsg(String.format("[%s]长度不能大于[%s]", "%s", max));
        }
        errorMsg = context.replaceParams(errorMsg);

        ValidationError validationError = new ValidationError()
                .setValidator(this)
                .setField(this.getField())
                .setShortField(this.getShortField())
                .setFieldName(this.getFieldName())
                .setShortFieldName(this.getShortFieldName())
                .setErrorCode(this.getErrorCode())
                .setErrorMsg(errorMsg)
                .setErrorValue(target);
        context.addError(validationError);

        return false;
    }

    public Integer getMin() {
        return min;
    }

    public StringLengthValidator setMin(Integer min) {
        this.min = min;
        return this;
    }

    public Integer getMax() {
        return max;
    }

    public StringLengthValidator setMax(Integer max) {
        this.max = max;
        return this;
    }
}