package cn.zcltd.btg.validq.validator;

import cn.zcltd.btg.validq.ValidationError;
import cn.zcltd.btg.validq.ValidatorContext;
import cn.zcltd.btg.validq.ValidatorHandler;

import java.util.Collection;
import java.util.Map;

/**
 * 验证对象不能为empty
 */
public class IsNotEmptyValidator extends ValidatorHandler<Object> {

    public IsNotEmptyValidator() {
    }

    public IsNotEmptyValidator(String field, String fieldName) {
        super(field, fieldName);
    }

    public IsNotEmptyValidator(String field, String fieldName, String errorMsg) {
        super(field, fieldName, errorMsg);
    }

    @Override
    public int index() {
        return 4;
    }

    @Override
    public boolean validate(ValidatorContext context, Object target) {
        if (null == target) {
            return fail(context, target);
        }
        if (target instanceof Collection && ((Collection) target).size() == 0) {
            return fail(context, target);
        }
        if (target instanceof Map && ((Map) target).size() == 0) {
            return fail(context, target);
        }
        if (target instanceof Object[] && ((Object[]) target).length == 0) {
            return fail(context, target);
        }
        if (target instanceof String && ((String) target).trim().length() == 0) {
            return fail(context, target);
        }

        return true;
    }

    private boolean fail(ValidatorContext context, Object target) {
        String errorMsg = getDefaultMsg("[%s]不能为空");
        errorMsg = context.replaceParams(errorMsg);

        ValidationError validationError = new ValidationError()
                .setValidator(this)
                .setField(this.getField())
                .setShortField(this.getShortField())
                .setFieldName(this.getFieldName())
                .setShortFieldName(this.getShortFieldName())
                .setErrorCode(this.getErrorCode())
                .setErrorMsg(errorMsg)
                .setErrorValue(target);
        context.addError(validationError);

        return false;
    }
}