package cn.zcltd.btg.validq.validator;

import cn.zcltd.btg.validq.ValidationError;
import cn.zcltd.btg.validq.ValidatorContext;
import cn.zcltd.btg.validq.ValidatorHandler;

/**
 * 验证对象必须为null
 */
public class IsNullValidator extends ValidatorHandler<Object> {

    public IsNullValidator() {
    }

    public IsNullValidator(String field, String fieldName) {
        super(field, fieldName);
    }

    public IsNullValidator(String field, String fieldName, String errorMsg) {
        super(field, fieldName, errorMsg);
    }

    @Override
    public int index() {
        return 1;
    }

    @Override
    public boolean validate(ValidatorContext context, Object target) {
        if (null == target) {
            return true;
        }

        String errorMsg = getDefaultMsg("[%s]必须为空");
        errorMsg = context.replaceParams(errorMsg);

        ValidationError validationError = new ValidationError()
                .setValidator(this)
                .setField(this.getField())
                .setShortField(this.getShortField())
                .setFieldName(this.getFieldName())
                .setShortFieldName(this.getShortFieldName())
                .setErrorCode(this.getErrorCode())
                .setErrorMsg(errorMsg)
                .setErrorValue(target);
        context.addError(validationError);

        return false;
    }
}