package cn.zcltd.btg.validq.validator;

import cn.zcltd.btg.validq.ValidationError;
import cn.zcltd.btg.validq.ValidatorContext;
import cn.zcltd.btg.validq.ValidatorHandler;
import cn.zcltd.btg.validq.exception.ValidQException;

/**
 * 验证String是否符合正则匹配
 */
public class StringRegexValidator extends ValidatorHandler<String> {

    private String regex;

    public StringRegexValidator() {
    }

    public StringRegexValidator(String field, String fieldName) {
        super(field, fieldName);
    }

    public StringRegexValidator(String field, String fieldName, String errorMsg) {
        super(field, fieldName, errorMsg);
    }

    @Override
    public int index() {
        return 6;
    }

    @Override
    public boolean validate(ValidatorContext context, String target) {
        if (target == null || target.trim().length() == 0) {
            return true;
        }
        if (regex == null || regex.trim().length() == 0) {
            throw new ValidQException("regex string can not be empty");
        }
        if (target.matches(regex)) {
            return true;
        }

        String errorMsg = getDefaultMsg("[%s]格式不正确");
        errorMsg = context.replaceParams(errorMsg);

        ValidationError validationError = new ValidationError()
                .setValidator(this)
                .setField(this.getField())
                .setShortField(this.getShortField())
                .setFieldName(this.getFieldName())
                .setShortFieldName(this.getShortFieldName())
                .setErrorCode(this.getErrorCode())
                .setErrorMsg(errorMsg)
                .setErrorValue(target);
        context.addError(validationError);

        return false;
    }

    public String getRegex() {
        return regex;
    }

    public StringRegexValidator setRegex(String regex) {
        this.regex = regex;
        return this;
    }
}