/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.jdapp.kits;

import cn.zhucongqi.jdapp.server.core.IJdappServer;
import com.jfinal.log.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;

public final class JdappKit {
    private static String daemon = "jdapp-daemon";
    private static String format = "conf/%s%d.pid";
    private static String application = "conf/application.jdapp";
    private static Log log = Log.getLog(JdappKit.class);

    private static boolean saveApplicationName(String applicationName) {
        String fileName = String.format(application, applicationName);
        File file = new File(fileName);
        try {
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write(applicationName.getBytes("UTF-8"));
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
            return false;
        }
        return true;
    }

    private static boolean saveJdappPid(IJdappServer jdappServer) {
        String pid = JdappKit.currentAppPid();
        String fileName = String.format(format, daemon, jdappServer.serverId());
        File file = new File(fileName);
        try {
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write(pid.getBytes("UTF-8"));
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            log.error(ex.getMessage());
            return false;
        }
        return true;
    }

    public static String currentAppPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static boolean save(IJdappServer jdappServer) {
        return JdappKit.saveApplicationName(jdappServer.serverName()) && JdappKit.saveJdappPid(jdappServer);
    }
}

