/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel;

import cn.zhucongqi.excel.consts.SheetConsts;
import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.metadata.Table;
import cn.zhucongqi.excel.support.ExcelTypeEnum;
import cn.zhucongqi.excel.write.Builder;
import cn.zhucongqi.excel.write.BuilderImpl;
import java.io.OutputStream;
import java.util.List;

public class Writer {
    private Builder builder = new BuilderImpl();

    public Writer(OutputStream outputStream, ExcelTypeEnum typeEnum) {
        this(outputStream, typeEnum, true);
    }

    public Writer(OutputStream outputStream, ExcelTypeEnum typeEnum, boolean needHead) {
        this.builder.init(outputStream, typeEnum, needHead);
    }

    public Writer write(List<?> data) {
        if (null != data) {
            int dataSize = data.size();
            int sheetCnt = this.getSheetCount(dataSize);
            for (int i = 0; i < sheetCnt; ++i) {
                int start = i * SheetConsts.SHEET_MAX_ROW;
                int end = (i + 1) * SheetConsts.SHEET_MAX_ROW;
                end = end > dataSize ? dataSize : end;
                List<?> tmp = data.subList(start, end);
                Sheet sheet = new Sheet(i);
                sheet.setSheetName("Sheet" + (i + 1));
                this.builder.addContent(tmp, sheet);
            }
        }
        return this;
    }

    public Writer write(List<?> data, Sheet sheet) {
        this.builder.addContent(data, sheet);
        return this;
    }

    public Writer write0(List<List<String>> data, Sheet sheet) {
        this.builder.addContent(data, sheet);
        return this;
    }

    public Writer write(List<?> data, Sheet sheet, Table table) {
        this.builder.addContent(data, sheet, table);
        return this;
    }

    public Writer write0(List<List<String>> data, Sheet sheet, Table table) {
        this.builder.addContent(data, sheet, table);
        return this;
    }

    public void finish() {
        this.builder.finish();
    }

    private Integer getSheetCount(Integer dataSize) {
        if (dataSize == 0) {
            return 1;
        }
        return (int)Math.ceil((double)dataSize.intValue() / ((double)SheetConsts.SHEET_MAX_ROW.intValue() * 1.0));
    }
}

