/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.metadata;

import cn.zhucongqi.excel.annotation.ColumnIndex;
import cn.zhucongqi.excel.annotation.Property;
import cn.zhucongqi.excel.metadata.CellRange;
import cn.zhucongqi.excel.metadata.Column;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HeadProperty {
    private Class<?> headClazz;
    private List<List<String>> head = new ArrayList<List<String>>();
    private List<Column> columns = new ArrayList<Column>();
    private Map<Integer, Column> columnMap = new HashMap<Integer, Column>();

    public HeadProperty(Class<?> headClazz, List<List<String>> head) {
        this.headClazz = headClazz;
        this.head = head;
        this.initColumns();
    }

    private void initColumns() {
        if (this.headClazz != null) {
            Field[] fields = this.headClazz.getDeclaredFields();
            ArrayList<List<String>> headList = new ArrayList<List<String>>();
            for (Field f : fields) {
                this.initOneColumn(f);
            }
            Collections.sort(this.columns);
            if (this.head == null || this.head.size() == 0) {
                for (Column Column2 : this.columns) {
                    headList.add(Column2.getHead());
                }
                this.head = headList;
            }
        }
    }

    private void initOneColumn(Field f) {
        Property p = f.getAnnotation(Property.class);
        Column header = null;
        if (p != null) {
            header = new Column();
            header.setField(f);
            header.setHead(Arrays.asList(p.value()));
            header.setIndex(p.index());
            header.setDateFormat(p.format());
            this.columnMap.put(p.index(), header);
        } else {
            ColumnIndex columnNum = f.getAnnotation(ColumnIndex.class);
            if (columnNum != null) {
                header = new Column();
                header.setField(f);
                header.setIndex(columnNum.value());
                header.setDateFormat(columnNum.format());
                this.columnMap.put(columnNum.value(), header);
            }
        }
        if (header != null) {
            this.columns.add(header);
        }
    }

    public void appendOneRow(List<String> row) {
        for (int i = 0; i < row.size(); ++i) {
            List<Object> list;
            if (this.head.size() <= i) {
                list = new ArrayList();
                this.head.add(list);
            } else {
                list = this.head.get(0);
            }
            list.add(row.get(i));
        }
    }

    public Column getExcelColumnProperty(int columnNum) {
        Column Column2 = this.columnMap.get(columnNum);
        if (Column2 == null && this.head != null && this.head.size() > columnNum) {
            List<String> columnHead = this.head.get(columnNum);
            for (Column colProperty : this.columns) {
                if (!this.headEquals(columnHead, colProperty.getHead())) continue;
                return colProperty;
            }
        }
        return Column2;
    }

    public Column getExcelColumnProperty1(int columnNum) {
        return this.columnMap.get(columnNum);
    }

    private boolean headEquals(List<String> columnHead, List<String> head) {
        boolean result = true;
        if (columnHead == null || head == null || columnHead.size() != head.size()) {
            return false;
        }
        for (int i = 0; i < head.size(); ++i) {
            if (head.get(i).equals(columnHead.get(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public Class<?> getHeadClazz() {
        return this.headClazz;
    }

    public void setHeadClazz(Class<?> headClazz) {
        this.headClazz = headClazz;
    }

    public List<List<String>> getHead() {
        return this.head;
    }

    public void setHead(List<List<String>> head) {
        this.head = head;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<CellRange> getCellRangeModels() {
        ArrayList<CellRange> rangs = new ArrayList<CellRange>();
        for (int i = 0; i < this.head.size(); ++i) {
            List<String> columnvalues = this.head.get(i);
            for (int j = 0; j < columnvalues.size(); ++j) {
                int lastRow = this.getLastRangRow(j, columnvalues.get(j), columnvalues);
                int lastColumn = this.getLastRangColumn(columnvalues.get(j), this.getHeadByRowNum(j), i);
                if (lastRow < 0 || lastColumn < 0 || lastRow <= j && lastColumn <= i) continue;
                rangs.add(new CellRange(j, lastRow, i, lastColumn));
            }
        }
        return rangs;
    }

    public List<String> getHeadByRowNum(int rowNum) {
        ArrayList<String> l = new ArrayList<String>(this.head.size());
        for (List<String> list : this.head) {
            if (list.size() > rowNum) {
                l.add(list.get(rowNum));
                continue;
            }
            l.add(list.get(list.size() - 1));
        }
        return l;
    }

    private int getLastRangColumn(String value, List<String> headByRowNum, int i) {
        if (headByRowNum.indexOf(value) < i) {
            return -1;
        }
        return headByRowNum.lastIndexOf(value);
    }

    private int getLastRangRow(int j, String value, List<String> columnvalue) {
        if (columnvalue.indexOf(value) < j) {
            return -1;
        }
        if (value != null && value.equals(columnvalue.get(columnvalue.size() - 1))) {
            return this.getRowNum() - 1;
        }
        return columnvalue.lastIndexOf(value);
    }

    public int getRowNum() {
        int headRowNum = 0;
        for (List<String> list : this.head) {
            if (list == null || list.size() <= 0 || list.size() <= headRowNum) continue;
            headRowNum = list.size();
        }
        return headRowNum;
    }
}

