/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.read;

import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.read.ExcelAnalyser;
import cn.zhucongqi.excel.read.context.AnalysisContext;
import cn.zhucongqi.excel.read.event.AnalysisEventListener;
import cn.zhucongqi.excel.read.event.AnalysisEventRegisterCenter;
import cn.zhucongqi.excel.read.event.OneRowAnalysisFinishEvent;
import cn.zhucongqi.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseSaxAnalyser
implements AnalysisEventRegisterCenter,
ExcelAnalyser {
    protected AnalysisContext analysisContext;
    private LinkedHashMap<String, AnalysisEventListener<?>> listeners = new LinkedHashMap();

    protected abstract void execute();

    @Override
    public void init(InputStream inputStream, ExcelTypeEnum excelTypeEnum, Object custom, AnalysisEventListener<?> eventListener, boolean trim) {
    }

    @Override
    public void appendLister(String name, AnalysisEventListener<?> listener) {
        if (!this.listeners.containsKey(name)) {
            this.listeners.put(name, listener);
        }
    }

    @Override
    public void analysis(Sheet sheetParam) {
        this.execute();
    }

    @Override
    public void analysis() {
        this.execute();
    }

    @Override
    public void cleanAllListeners() {
        this.listeners = new LinkedHashMap();
    }

    @Override
    public void notifyListeners(OneRowAnalysisFinishEvent event) {
        this.analysisContext.setCurrentRowAnalysisResult(event.getData());
        if (this.analysisContext.getCurrentRowNum() < this.analysisContext.getCurrentSheet().getHeadLineMun()) {
            if (this.analysisContext.getCurrentRowNum() <= this.analysisContext.getCurrentSheet().getHeadLineMun() - 1) {
                this.analysisContext.buildExcelHeadProperty(null, (List)this.analysisContext.getCurrentRowAnalysisResult());
            }
        } else {
            this.analysisContext.setCurrentRowAnalysisResult(event.getData());
            for (Map.Entry<String, AnalysisEventListener<?>> entry : this.listeners.entrySet()) {
                entry.getValue().invoke(this.analysisContext.getCurrentRowAnalysisResult(), this.analysisContext);
            }
        }
    }
}

