/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.read.context;

import cn.zhucongqi.excel.metadata.HeadProperty;
import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.read.context.AnalysisContext;
import cn.zhucongqi.excel.read.event.AnalysisEventListener;
import cn.zhucongqi.excel.read.exception.AnalysisException;
import cn.zhucongqi.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class AnalysisContextImpl
implements AnalysisContext {
    private Object custom;
    private Sheet currentSheet;
    private ExcelTypeEnum excelType;
    private InputStream inputStream;
    private AnalysisEventListener<?> eventListener;
    private Integer currentRowNum;
    private Integer totalCount;
    private HeadProperty headProperty;
    private boolean trim;
    private boolean use1904WindowDate = false;
    private Object currentRowAnalysisResult;

    @Override
    public void setUse1904WindowDate(boolean use1904WindowDate) {
        this.use1904WindowDate = use1904WindowDate;
    }

    @Override
    public <T> T getCurrentRowAnalysisResult() {
        return (T)this.currentRowAnalysisResult;
    }

    @Override
    public void interrupt() {
        throw new AnalysisException("interrupt error");
    }

    @Override
    public boolean use1904WindowDate() {
        return this.use1904WindowDate;
    }

    @Override
    public void setCurrentRowAnalysisResult(Object currentRowAnalysisResult) {
        this.currentRowAnalysisResult = currentRowAnalysisResult;
    }

    public AnalysisContextImpl(InputStream inputStream, ExcelTypeEnum excelTypeEnum, Object custom, AnalysisEventListener<?> listener, boolean trim) {
        this.custom = custom;
        this.eventListener = listener;
        this.inputStream = inputStream;
        this.excelType = excelTypeEnum;
        this.trim = trim;
    }

    @Override
    public void setCurrentSheet(Sheet currentSheet) {
        this.currentSheet = currentSheet;
        if (currentSheet.getClazz() != null) {
            this.buildExcelHeadProperty(currentSheet.getClazz(), null);
        }
    }

    @Override
    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    @Override
    public Object getCustom() {
        return this.custom;
    }

    public void setCustom(Object custom) {
        this.custom = custom;
    }

    @Override
    public Sheet getCurrentSheet() {
        return this.currentSheet;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public AnalysisEventListener<?> getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(AnalysisEventListener<?> eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public Integer getCurrentRowNum() {
        return this.currentRowNum;
    }

    @Override
    public void setCurrentRowNum(Integer row) {
        this.currentRowNum = row;
    }

    @Override
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Override
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    public HeadProperty getExcelHeadProperty() {
        return this.headProperty;
    }

    @Override
    public void buildExcelHeadProperty(Class<?> clazz, List<String> headOneRow) {
        if (this.headProperty == null && (clazz != null || headOneRow != null)) {
            this.headProperty = new HeadProperty(clazz, new ArrayList<List<String>>());
        }
        if (this.headProperty.getHead() == null && headOneRow != null) {
            this.headProperty.appendOneRow(headOneRow);
        }
    }

    @Override
    public boolean trim() {
        return this.trim;
    }
}

