/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.write;

import cn.zhucongqi.excel.kit.TempFile;
import cn.zhucongqi.excel.metadata.Column;
import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.metadata.Table;
import cn.zhucongqi.excel.support.ExcelTypeEnum;
import cn.zhucongqi.excel.write.Builder;
import cn.zhucongqi.excel.write.context.GenerateContext;
import cn.zhucongqi.excel.write.context.GenerateContextImpl;
import com.jfinal.plugin.activerecord.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class BuilderImpl
implements Builder {
    private GenerateContext context;
    private OutputStream outputsteam;

    @Override
    public void init(OutputStream out, ExcelTypeEnum excelType, boolean needHead) {
        TempFile.createPOIFilesDirectory();
        this.outputsteam = out;
        this.context = new GenerateContextImpl(excelType, needHead);
    }

    @Override
    public void addContent(List<?> data) {
        if (data != null && data.size() > 0) {
            Row row;
            int rowNum = this.context.getCurrentSheet().getLastRowNum();
            if (!(rowNum != 0 || (row = this.context.getCurrentSheet().getRow(0)) != null || this.context.getExcelHeadProperty() != null && this.context.needHead())) {
                rowNum = -1;
            }
            for (int i = 0; i < data.size(); ++i) {
                int n = i + rowNum + 1;
                this.addOneRowOfDataToExcel(data.get(i), n);
            }
        }
    }

    @Override
    public void addContent(List<?> data, Sheet sheetParam) {
        this.context.buildSheet(sheetParam);
        this.addContent(data);
    }

    @Override
    public void addContent(List<?> data, Sheet sheetParam, Table table) {
        this.context.buildSheet(sheetParam);
        this.context.buildTable(table);
        this.addContent(data);
    }

    @Override
    public void finish() {
        try {
            this.context.getWorkbook().write(this.outputsteam);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addOneRowOfDataToExcel(List<String> oneRowData, Row row) {
        if (oneRowData != null && oneRowData.size() > 0) {
            for (int i = 0; i < oneRowData.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(this.context.getCurrentContentStyle());
                cell.setCellValue(oneRowData.get(i));
            }
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, Row row) {
        int i = 0;
        for (Column excelHeadProperty : this.context.getExcelHeadProperty().getColumns()) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.context.getCurrentContentStyle());
            String cellValue = null;
            try {
                cellValue = BeanUtils.getProperty((Object)oneRowData, (String)excelHeadProperty.getField().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (cellValue != null) {
                cell.setCellValue(cellValue);
            } else {
                cell.setCellValue("");
            }
            ++i;
        }
    }

    private void addModelToExcel(Model<?> model, Row row) {
        String[] attrs = model._getAttrNames();
        for (int i = 0; i < attrs.length; ++i) {
            String attr = attrs[i];
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.context.getCurrentContentStyle());
            Object val = model.get(attr);
            if (null == val) {
                cell.setCellValue("");
                continue;
            }
            cell.setCellValue(model.get(attr).toString());
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n) {
        Row row = this.context.getCurrentSheet().createRow(n);
        if (oneRowData instanceof List) {
            this.addOneRowOfDataToExcel((List)oneRowData, row);
        } else if (Model.class.isAssignableFrom(oneRowData.getClass())) {
            this.addModelToExcel((Model)oneRowData, row);
        } else {
            this.addOneRowOfDataToExcel(oneRowData, row);
        }
    }
}

