/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel;

import cn.zhucongqi.excel.kit.FileKit;
import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.read.ExcelAnalyser;
import cn.zhucongqi.excel.read.ExcelAnalyserImpl;
import cn.zhucongqi.excel.read.event.AnalysisEventListener;
import cn.zhucongqi.excel.support.ExcelTypeEnum;
import cn.zhucongqi.excel.support.TypeDetection;
import com.jfinal.kit.StrKit;
import java.io.InputStream;
import java.util.List;

public class Reader {
    private ExcelAnalyser analyser = new ExcelAnalyserImpl();

    public Reader(String fileName, Object customContent, AnalysisEventListener<?> eventListener) {
        this.validateParam(fileName);
        InputStream in = FileKit.getInputStream(fileName);
        ExcelTypeEnum excelTypeEnum = TypeDetection.getExcelType(fileName);
        this.validateParam(in, excelTypeEnum, eventListener);
        this.analyser.init(in, excelTypeEnum, customContent, eventListener, true);
    }

    public Reader(String fileName, Object customContent, AnalysisEventListener<?> eventListener, boolean trim) {
        this.validateParam(fileName);
        InputStream in = FileKit.getInputStream(fileName);
        ExcelTypeEnum excelTypeEnum = TypeDetection.getExcelType(fileName);
        this.validateParam(in, excelTypeEnum, eventListener);
        this.analyser.init(in, excelTypeEnum, customContent, eventListener, trim);
    }

    public Reader(InputStream in, ExcelTypeEnum excelTypeEnum, Object customContent, AnalysisEventListener<?> eventListener) {
        this(in, excelTypeEnum, customContent, eventListener, true);
    }

    public Reader(InputStream in, ExcelTypeEnum excelTypeEnum, Object customContent, AnalysisEventListener<?> eventListener, boolean trim) {
        this.validateParam(in, excelTypeEnum, eventListener);
        this.analyser.init(in, excelTypeEnum, customContent, eventListener, trim);
    }

    public void read() {
        this.analyser.analysis();
    }

    public void read(Sheet sheet) {
        this.analyser.analysis(sheet);
    }

    public List<Sheet> getSheets() {
        return this.analyser.getSheets();
    }

    public void finish() {
        this.analyser.stop();
    }

    private void validateParam(String fileName) {
        if (StrKit.isBlank((String)fileName) || !fileName.endsWith(ExcelTypeEnum.XLSX.getValue()) && !fileName.endsWith(ExcelTypeEnum.XLS.getValue())) {
            throw new IllegalArgumentException("Please use the .xls or .xlsx file.");
        }
    }

    private void validateParam(InputStream in, ExcelTypeEnum excelTypeEnum, AnalysisEventListener<?> eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("AnalysisEventListener can not null");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream can not null");
        }
        if (excelTypeEnum == null) {
            throw new IllegalArgumentException("excelTypeEnum can not null");
        }
    }
}

