/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.kit;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class TypeKit {
    private static List<SimpleDateFormat> DATE_FORMAT_LIST = new ArrayList<SimpleDateFormat>(4);
    public static final Pattern pattern;

    public static Object convert(String value, Class<?> type, String format, boolean us) {
        if (TypeKit.isNotEmpty(value).booleanValue()) {
            if (String.class.equals(type)) {
                return value;
            }
            if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
                return Integer.parseInt(value);
            }
            if (Double.class.equals(type) || Double.TYPE.equals(type)) {
                return Double.parseDouble(value);
            }
            if (Float.class.equals(type) || Float.TYPE.equals(type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
                String valueLower = value.toLowerCase();
                if (valueLower.equals("true") || valueLower.equals("false")) {
                    return Boolean.parseBoolean(value.toLowerCase());
                }
                Integer integer = Integer.parseInt(value);
                if (integer == 0) {
                    return false;
                }
                return true;
            }
            if (Long.class.equals(type) || Long.TYPE.equals(type)) {
                return Long.parseLong(value);
            }
            if (BigInteger.class.equals(type)) {
                return new BigInteger(value);
            }
            if (byte[].class.equals(type)) {
                return value.getBytes();
            }
            if (Short.class.equals(type)) {
                return Short.parseShort(value);
            }
            if (Byte.class.equals(type)) {
                return Byte.parseByte(value);
            }
            if (java.util.Date.class.equals(type) || Date.class.equals(type) || Time.class.equals(type) || Timestamp.class.equals(type)) {
                java.util.Date date;
                if (value.contains("-") || value.contains("/") || value.contains(":")) {
                    date = TypeKit.getSimpleDateFormatDate(value, format);
                } else {
                    Double d = Double.parseDouble(value);
                    date = HSSFDateUtil.getJavaDate((double)d, (boolean)us);
                }
                if (Date.class.equals(type)) {
                    return new Date(date.getTime());
                }
                if (Time.class.equals(type)) {
                    return new Time(date.getTime());
                }
                if (Timestamp.class.equals(type)) {
                    return new Timestamp(date.getTime());
                }
                return date;
            }
            if (BigDecimal.class.equals(type)) {
                return new BigDecimal(value);
            }
        }
        return null;
    }

    public static Object convert(String value, Field field, String format, boolean us) {
        return TypeKit.convert(value, field.getType(), format, us);
    }

    public static String getDefaultDateString(java.util.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static java.util.Date getSimpleDateFormatDate(String value, String format) {
        if (TypeKit.isNotEmpty(value).booleanValue()) {
            java.util.Date date = null;
            if (TypeKit.isNotEmpty(format).booleanValue()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
                try {
                    date = simpleDateFormat.parse(value);
                    return date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            for (SimpleDateFormat dateFormat : DATE_FORMAT_LIST) {
                try {
                    date = dateFormat.parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (date == null) continue;
                break;
            }
            return date;
        }
        return null;
    }

    private static Boolean isNotEmpty(String value) {
        if (value == null) {
            return false;
        }
        if (value.trim().equals("")) {
            return false;
        }
        return true;
    }

    public static String formatFloat(String value) {
        if (value.contains(".") && TypeKit.isNumeric(value)) {
            try {
                BigDecimal decimal = new BigDecimal(value);
                BigDecimal setScale = decimal.setScale(10, 5).stripTrailingZeros();
                return setScale.toPlainString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private static boolean isNumeric(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    static {
        DATE_FORMAT_LIST.add(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
        DATE_FORMAT_LIST.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        pattern = Pattern.compile("[\\+\\-]?[\\d]+([\\.][\\d]*)?([Ee][+-]?[\\d]+)?$");
    }
}

