/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.metadata;

import cn.zhucongqi.excel.annotation.ColumnIndex;
import cn.zhucongqi.excel.annotation.Property;
import cn.zhucongqi.excel.metadata.CellRange;
import cn.zhucongqi.excel.metadata.Column;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Header {
    private Integer headerLineCnt;
    private Class<?> headerClazz;
    private List<List<String>> headerTitles = new ArrayList<List<String>>();
    private List<Column> headerColumns = new ArrayList<Column>();
    private Map<Integer, Column> headerColumnMap = new HashMap<Integer, Column>();

    public Header() {
    }

    public Header(Integer headerlineCnt) {
        this.headerLineCnt = headerlineCnt;
    }

    public Header(Integer headerlineCnt, String[] headerTitle) {
        this.headerLineCnt = headerlineCnt;
        this.appendOneHeaderRow(Arrays.asList(headerTitle));
    }

    public Header(Integer headerlineCnt, List<String> headerTitle) {
        this.headerLineCnt = headerlineCnt;
        this.headerTitles.add(headerTitle);
    }

    public Header(Class<?> headClazz, Integer headerLineCnt) {
        this.headerClazz = headClazz;
        this.setHeadLineCnt(headerLineCnt);
    }

    public Header(Class<?> headClazz, List<List<String>> headerTitles) {
        this.headerClazz = headClazz;
        this.headerTitles = headerTitles;
        this.initHeaderColumns();
    }

    private void initHeaderColumns() {
        if (this.headerClazz != null) {
            Field[] fields;
            for (Field f : fields = this.headerClazz.getDeclaredFields()) {
                this.initOneHeaderColumn(f);
            }
            Collections.sort(this.headerColumns);
            ArrayList<List<String>> headerTitles = new ArrayList<List<String>>();
            if (!this.hasHeaderTitles().booleanValue()) {
                for (Column col : this.headerColumns) {
                    headerTitles.add(col.getHead());
                }
                this.headerTitles = headerTitles;
            }
        }
    }

    private void initOneHeaderColumn(Field f) {
        Property p = f.getAnnotation(Property.class);
        Column headerCol = null;
        if (p != null) {
            headerCol = new Column();
            headerCol.setField(f);
            headerCol.setHead(Arrays.asList(p.value()));
            headerCol.setIndex(p.index());
            headerCol.setDateFormat(p.format());
            this.headerColumnMap.put(p.index(), headerCol);
        } else {
            ColumnIndex columnNum = f.getAnnotation(ColumnIndex.class);
            if (columnNum != null) {
                headerCol = new Column();
                headerCol.setField(f);
                headerCol.setIndex(columnNum.value());
                headerCol.setDateFormat(columnNum.format());
                this.headerColumnMap.put(columnNum.value(), headerCol);
            }
        }
        if (headerCol != null) {
            this.headerColumns.add(headerCol);
        }
    }

    public void appendOneHeaderRow(List<String> row) {
        for (int i = 0; i < row.size(); ++i) {
            List<Object> oneHeader;
            if (this.headerTitles.size() <= i) {
                oneHeader = new ArrayList();
                this.headerTitles.add(oneHeader);
            } else {
                oneHeader = this.headerTitles.get(0);
            }
            oneHeader.add(row.get(i));
        }
    }

    public Column getHeaderColumnByIdx(Integer columnIdx) {
        Column Column2 = this.headerColumnMap.get(columnIdx);
        if (Column2 == null && this.headerTitles != null && this.headerTitles.size() > columnIdx) {
            List<String> columnHead = this.headerTitles.get(columnIdx);
            for (Column col : this.headerColumns) {
                if (!this.headerEquals(columnHead, col.getHead())) continue;
                return col;
            }
        }
        return Column2;
    }

    public Column getHeaderColumnByIdx1(Integer columnIdx) {
        return this.headerColumnMap.get(columnIdx);
    }

    private boolean headerEquals(List<String> columnHeader, List<String> header) {
        boolean result = true;
        if (columnHeader == null || header == null || columnHeader.size() != header.size()) {
            return false;
        }
        for (int i = 0; i < header.size(); ++i) {
            if (header.get(i).equals(columnHeader.get(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public List<CellRange> getCellRangeModels() {
        ArrayList<CellRange> rangs = new ArrayList<CellRange>();
        for (int i = 0; i < this.headerTitles.size(); ++i) {
            List<String> columnvalues = this.headerTitles.get(i);
            for (int j = 0; j < columnvalues.size(); ++j) {
                int lastRow = this.getLastRangRow(j, columnvalues.get(j), columnvalues);
                int lastColumn = this.getLastRangColumn(columnvalues.get(j), this.getHeaderByRowIdx(j), i);
                if (lastRow < 0 || lastColumn < 0 || lastRow <= j && lastColumn <= i) continue;
                rangs.add(new CellRange(j, lastRow, i, lastColumn));
            }
        }
        return rangs;
    }

    public List<String> getHeaderByRowIdx(Integer rowIdx) {
        ArrayList<String> l = new ArrayList<String>(this.headerTitles.size());
        for (List<String> list : this.headerTitles) {
            if (list.size() > rowIdx) {
                l.add(list.get(rowIdx));
                continue;
            }
            l.add(list.get(list.size() - 1));
        }
        return l;
    }

    private int getLastRangColumn(String value, List<String> headByRowNum, int i) {
        if (headByRowNum.indexOf(value) < i) {
            return -1;
        }
        return headByRowNum.lastIndexOf(value);
    }

    private int getLastRangRow(int j, String value, List<String> columnvalue) {
        if (columnvalue.indexOf(value) < j) {
            return -1;
        }
        if (value != null && value.equals(columnvalue.get(columnvalue.size() - 1))) {
            return this.getRowNum() - 1;
        }
        return columnvalue.lastIndexOf(value);
    }

    public Integer getRowNum() {
        int rowCnt = 0;
        for (List<String> list : this.headerTitles) {
            if (list == null || list.size() <= 0 || list.size() <= rowCnt) continue;
            rowCnt = list.size();
        }
        return rowCnt;
    }

    public Boolean hasHeaderTitles() {
        return this.headerTitles != null && this.headerTitles.size() > 0;
    }

    public Integer getHeadLineCnt() {
        return this.headerLineCnt;
    }

    public void setHeadLineCnt(Integer headLineCnt) {
        this.headerLineCnt = headLineCnt;
    }

    public Integer getHeaderLineCnt() {
        return this.headerLineCnt;
    }

    public void setHeaderLineCnt(Integer headerLineCnt) {
        this.headerLineCnt = headerLineCnt;
    }

    public Class<?> getHeaderClazz() {
        return this.headerClazz;
    }

    public void setHeaderClazz(Class<?> headerClazz) {
        this.headerClazz = headerClazz;
    }

    public List<List<String>> getHeaderTitles() {
        return this.headerTitles;
    }

    public void setHeaderTitles(List<List<String>> headerTitles) {
        this.headerTitles = headerTitles;
    }

    public List<Column> getHeaderColumns() {
        return this.headerColumns;
    }

    public void setHeaderColumns(List<Column> headerColumns) {
        this.headerColumns = headerColumns;
    }

    public Map<Integer, Column> getHeaderColumnMap() {
        return this.headerColumnMap;
    }

    public void setHeaderColumnMap(Map<Integer, Column> headerColumnMap) {
        this.headerColumnMap = headerColumnMap;
    }
}

