/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.read;

import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.read.BaseSaxAnalyser;
import cn.zhucongqi.excel.read.ExcelAnalyser;
import cn.zhucongqi.excel.read.SaxAnalyserV03;
import cn.zhucongqi.excel.read.SaxAnalyserV07;
import cn.zhucongqi.excel.read.context.AnalysisContext;
import cn.zhucongqi.excel.read.context.AnalysisContextImpl;
import cn.zhucongqi.excel.read.event.AnalysisEventListener;
import cn.zhucongqi.excel.read.event.ClassReflectBuildListener;
import cn.zhucongqi.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.List;

public class ExcelAnalyserImpl
implements ExcelAnalyser {
    private AnalysisContext analysisContext;
    private BaseSaxAnalyser saxAnalyser;

    private BaseSaxAnalyser getSaxAnalyser() {
        if (this.saxAnalyser == null) {
            if (ExcelTypeEnum.XLS.equals((Object)this.analysisContext.getExcelType())) {
                this.saxAnalyser = new SaxAnalyserV03(this.analysisContext);
            } else {
                try {
                    this.saxAnalyser = new SaxAnalyserV07(this.analysisContext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.saxAnalyser;
    }

    @Override
    public void init(InputStream inputStream, ExcelTypeEnum excelTypeEnum, Object custom, AnalysisEventListener<?> eventListener, boolean trim) {
        this.analysisContext = new AnalysisContextImpl(inputStream, excelTypeEnum, custom, eventListener, trim);
    }

    @Override
    public void analysis(Sheet sheetParam) {
        this.analysisContext.setCurrentSheet(sheetParam);
        this.analysis();
    }

    @Override
    public void analysis() {
        BaseSaxAnalyser saxAnalyser = this.getSaxAnalyser();
        this.appendListeners(saxAnalyser);
        saxAnalyser.execute();
        this.analysisContext.getEventListener().doAfterAllAnalysed(this.analysisContext);
    }

    @Override
    public List<Sheet> getSheets() {
        BaseSaxAnalyser saxAnalyser = this.getSaxAnalyser();
        saxAnalyser.cleanAllListeners();
        return saxAnalyser.getSheets();
    }

    @Override
    public void stop() {
        this.saxAnalyser.stop();
    }

    private void appendListeners(BaseSaxAnalyser saxAnalyser) {
        if (this.analysisContext.getCurrentSheet() != null && this.analysisContext.getCurrentSheet().getClazz() != null) {
            saxAnalyser.appendLister("class_reflect_build_listener", new ClassReflectBuildListener());
        }
        if (this.analysisContext.getEventListener() != null) {
            saxAnalyser.appendLister("user_define_listener", this.analysisContext.getEventListener());
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }
}

