/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.read;

import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.read.BaseSaxAnalyser;
import cn.zhucongqi.excel.read.context.AnalysisContext;
import cn.zhucongqi.excel.read.event.OneRowAnalysisFinishEvent;
import cn.zhucongqi.excel.read.exception.AnalysisException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class SaxAnalyserV03
extends BaseSaxAnalyser
implements HSSFListener {
    private boolean analyAllSheet = false;
    private POIFSFileSystem fs;
    private int lastRowNumber;
    private int lastColumnNumber;
    private boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private int sheetIndex;
    private List<String> records;
    private boolean notAllEmpty = false;
    private BoundSheetRecord[] orderedBSRs;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private List<Sheet> sheets = new ArrayList<Sheet>();

    public SaxAnalyserV03(AnalysisContext context) {
        this.analysisContext = context;
        this.records = new ArrayList<String>();
        if (this.analysisContext.getCurrentSheet() == null) {
            this.analyAllSheet = true;
        }
        context.setCurrentRowIdx(0);
        try {
            this.fs = new POIFSFileSystem(this.analysisContext.getInputStream());
        }
        catch (IOException e) {
            throw new AnalysisException(e);
        }
    }

    @Override
    public List<Sheet> getSheets() {
        this.execute();
        return this.sheets;
    }

    @Override
    public void stop() {
    }

    @Override
    public void execute() {
        this.init();
        MissingRecordAwareHSSFListener listener = new MissingRecordAwareHSSFListener((HSSFListener)this);
        this.formatListener = new FormatTrackingHSSFListener((HSSFListener)listener);
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        if (this.outputFormulaValues) {
            request.addListenerForAllRecords((HSSFListener)this.formatListener);
        } else {
            this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
            request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
        }
        try {
            factory.processWorkbookEvents(request, this.fs);
        }
        catch (IOException e) {
            throw new AnalysisException(e);
        }
    }

    private void init() {
        this.lastRowNumber = 0;
        this.lastColumnNumber = 0;
        this.nextRow = 0;
        this.nextColumn = 0;
        this.sheetIndex = 0;
        this.records = new ArrayList<String>();
        this.notAllEmpty = false;
        this.orderedBSRs = null;
        this.boundSheetRecords = new ArrayList<BoundSheetRecord>();
        this.sheets = new ArrayList<Sheet>();
        this.analyAllSheet = this.analysisContext.getCurrentSheet() == null;
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                }
                ++this.sheetIndex;
                Sheet sheet = new Sheet(this.sheetIndex, 0);
                sheet.setSheetName(this.orderedBSRs[this.sheetIndex - 1].getSheetname());
                this.sheets.add(sheet);
                if (!this.analyAllSheet) break;
                this.analysisContext.setCurrentSheet(sheet);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                thisStr = "";
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisStr = "";
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                if (this.outputFormulaValues) {
                    if (Double.isNaN(frec.getValue())) {
                        this.outputNextStringRecord = true;
                        this.nextRow = frec.getRow();
                        this.nextColumn = frec.getColumn();
                        break;
                    }
                    thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                    break;
                }
                thisStr = HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression());
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                thisStr = srec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                thisStr = lrec.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                if (this.sstRecord == null) {
                    thisStr = "";
                    break;
                }
                thisStr = this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                break;
            }
            case 28: {
                NoteRecord nrec = (NoteRecord)record;
                thisRow = nrec.getRow();
                thisColumn = nrec.getColumn();
                thisStr = "(TODO)";
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec);
                break;
            }
            case 638: {
                RKRecord rkrec = (RKRecord)record;
                thisRow = rkrec.getRow();
                thisColumn = rkrec.getColumn();
                thisStr = "";
                break;
            }
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastColumnNumber = -1;
        }
        if (record instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
            thisRow = mc.getRow();
            thisColumn = mc.getColumn();
            thisStr = "";
        }
        if (thisStr != null) {
            if (this.analysisContext.trim()) {
                thisStr = thisStr.trim();
            }
            if (!"".equals(thisStr)) {
                this.notAllEmpty = true;
            }
            this.records.add(thisStr);
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (thisColumn > -1) {
            this.lastColumnNumber = thisColumn;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            thisRow = ((LastCellOfRowDummyRecord)record).getRow();
            if (this.lastColumnNumber == -1) {
                this.lastColumnNumber = 0;
            }
            this.analysisContext.setCurrentRowIdx(thisRow);
            Sheet sheet = this.analysisContext.getCurrentSheet();
            if ((sheet == null || sheet.getSheetNo() == this.sheetIndex) && this.notAllEmpty) {
                this.notifyListeners(new OneRowAnalysisFinishEvent(this.copyList(this.records)));
            }
            this.records.clear();
            this.lastColumnNumber = -1;
            this.notAllEmpty = false;
        }
    }

    private List<String> copyList(List<String> data) {
        if (data == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String str : data) {
            list.add(new String(str));
        }
        return list;
    }
}

