/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.read.event;

import cn.zhucongqi.excel.kit.TypeKit;
import cn.zhucongqi.excel.metadata.Column;
import cn.zhucongqi.excel.metadata.Header;
import cn.zhucongqi.excel.read.context.AnalysisContext;
import cn.zhucongqi.excel.read.event.AnalysisEventListener;
import cn.zhucongqi.excel.write.exception.GenerateException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class ClassReflectBuildListener
extends AnalysisEventListener<Object> {
    @Override
    public void invoke(Object object, AnalysisContext context) {
        if (context.getHeader() != null && context.getHeader().getHeaderClazz() != null) {
            Object resultModel = this.buildUserModel(context, (List)object);
            context.setCurrentRowAnalysisResult(resultModel);
        }
    }

    private Object buildUserModel(AnalysisContext context, List<String> stringList) {
        Object resultModel;
        Header header = context.getHeader();
        try {
            resultModel = header.getHeaderClazz().newInstance();
        }
        catch (Exception e) {
            throw new GenerateException(e);
        }
        if (header != null) {
            for (int i = 0; i < stringList.size(); ++i) {
                Object value;
                Column column = header.getHeaderColumnByIdx1(i);
                if (column == null || (value = TypeKit.convert(stringList.get(i), column.getField(), column.getDateFormat(), context.use1904WindowDate())) == null) continue;
                try {
                    BeanUtils.setProperty(resultModel, (String)column.getField().getName(), (Object)value);
                    continue;
                }
                catch (Exception e) {
                    throw new GenerateException(column.getField().getName() + " can not set value " + value, e);
                }
            }
        }
        return resultModel;
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

