/*
 * Decompiled with CFR 0.152.
 */
package cn.zhucongqi.excel.read.event;

import cn.zhucongqi.excel.kit.TypeKit;
import cn.zhucongqi.excel.metadata.Column;
import cn.zhucongqi.excel.metadata.Rule;
import cn.zhucongqi.excel.metadata.Sheet;
import cn.zhucongqi.excel.read.context.AnalysisContext;
import cn.zhucongqi.excel.read.event.AnalysisEventListener;
import cn.zhucongqi.excel.write.exception.GenerateException;
import com.jfinal.plugin.activerecord.Model;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class JFModelReadListener
extends AnalysisEventListener<List<String>> {
    private List<Model<?>> datas = new ArrayList();
    private Rule rule;

    public <T> T getDatas() {
        return (T)this.datas;
    }

    public abstract Rule rule();

    public abstract void readRow(Model<?> var1);

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    @Override
    public void invoke(List<String> object, AnalysisContext context) {
        if (null == this.getRule()) {
            throw new GenerateException("Please set read rule first.");
        }
        Sheet sheet = context.getCurrentSheet();
        Integer currentRow = context.getCurrentRowIdx();
        if (sheet.hasHeader().booleanValue() && currentRow <= sheet.getHeaderLineCnt()) {
            return;
        }
        Class clazz = (Class)context.getCustom();
        Model model = null;
        if (Model.class.isAssignableFrom(clazz)) {
            try {
                model = (Model)clazz.newInstance();
            }
            catch (Exception e) {
                throw new GenerateException(e);
            }
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(byteOut);
                out.writeObject(object);
                ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
                ObjectInputStream in = new ObjectInputStream(byteIn);
                List dest = (List)in.readObject();
                for (int i = 0; i < dest.size(); ++i) {
                    String val;
                    Column col = this.getRule().getColumn(i);
                    if (null == col || null == (val = (String)dest.get(i))) continue;
                    String attr = col.getAttr();
                    Object value = TypeKit.convert(val, col.getType(), col.getDateFormat(), context.use1904WindowDate());
                    if (value == null) continue;
                    model.set(attr, value);
                }
            }
            catch (Exception e) {
                throw new GenerateException(e);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new GenerateException(e);
                    }
                }
                if (null != byteOut) {
                    try {
                        byteOut.close();
                    }
                    catch (IOException e) {
                        throw new GenerateException(e);
                    }
                }
            }
        }
        this.datas.add(model);
        this.readRow(model);
    }

    private Rule getRule() {
        if (null == this.rule) {
            this.rule = this.rule();
        }
        return this.rule;
    }
}

