/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.solon;

import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.filter.ArrayValueParamFilter;
import cn.zhxu.bs.filter.IndexArrayParamFilter;
import cn.zhxu.bs.filter.JsonArrayParamFilter;
import cn.zhxu.bs.filter.SizeLimitParamFilter;
import cn.zhxu.bs.filter.SuffixOpParamFilter;
import cn.zhxu.bs.solon.prop.BeanSearcherParams;
import cn.zhxu.bs.solon.prop.BeanSearcherProperties;
import cn.zhxu.xjson.JsonKit;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;

@Configuration
public class BeanSearcherParamFilters {
    @Inject
    BeanSearcherProperties config;

    @Bean(index=-100)
    @Condition(onMissingBean=SizeLimitParamFilter.class, onProperty="${bean-searcher.params.filter.use-size-limit:true}=true")
    public SizeLimitParamFilter sizeLimitParamFilter() {
        return new SizeLimitParamFilter(this.config.getParams().getFilter().getMaxParaMapSize());
    }

    @Bean(index=100)
    @Condition(onMissingBean=ArrayValueParamFilter.class, onProperty="${bean-searcher.params.filter.use-array-value:true}=true")
    public ArrayValueParamFilter arrayValueParamFilter() {
        return new ArrayValueParamFilter(this.config.getParams().getSeparator());
    }

    @Bean(index=200)
    @Condition(onMissingBean=SuffixOpParamFilter.class, onProperty="${bean-searcher.params.filter.use-suffix-op}=true")
    public SuffixOpParamFilter suffixOpParamFilter(FieldOpPool fieldOpPool) {
        BeanSearcherParams cfg = this.config.getParams();
        return new SuffixOpParamFilter(fieldOpPool, cfg.getSeparator(), cfg.getOperatorKey(), cfg.getIgnoreCaseKey());
    }

    @Bean(index=300)
    @Condition(onMissingBean=JsonArrayParamFilter.class, onClass=JsonKit.class, onProperty="${bean-searcher.params.filter.use-json-array}=true")
    public JsonArrayParamFilter jsonArrayParamFilter() {
        return new JsonArrayParamFilter(this.config.getParams().getSeparator());
    }

    @Bean(index=400)
    @Condition(onMissingBean=IndexArrayParamFilter.class, onProperty="${bean-searcher.params.filter.use-index-array}=true")
    public IndexArrayParamFilter indexArrayParamFilter(BeanSearcherParams config) {
        return new IndexArrayParamFilter(config.getSeparator());
    }
}

