package cn.zhxu.bp.auth;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Troy.Zhou @ 2022/8/2 17:22
 */
public class AuthRule {

    static final int TYPE_AUTHORITY = 1;
    static final int TYPE_OR_GROUP = 3;

    private final int type;

    /**
     * 关系为：且
     */
    private List<String> auths;

    /**
     * 关系为：或
     */
    private List<AuthRule> orRules;


    AuthRule(int type) {
        this.type = type;
    }

    public static AuthRule from(String authAttr) {
        if (authAttr.contains("|")) {
            var authRule = new AuthRule(AuthRule.TYPE_OR_GROUP);
            for (String authAttr0 : authAttr.split("\\|")) {
                var rule = new AuthRule(AuthRule.TYPE_AUTHORITY);
                rule.auths = List.of(authAttr0.split("&"));
                authRule.addOrRule(rule);
            }
            return authRule;
        }
        var rule = new AuthRule(AuthRule.TYPE_AUTHORITY);
        rule.auths = List.of(authAttr.split("&"));
        return rule;
    }

    private void addOrRule(AuthRule rule) {
        if (orRules == null) {
            orRules = new ArrayList<>(1);
        }
        orRules.add(rule);
    }

    public boolean isPermitAll() {
        return isPermit(List.of());
    }

    public boolean isPermit(List<String> authorities) {
        if (type == TYPE_AUTHORITY) {
            for (String auth: auths) {
                if (AuthConst.PERMIT_ALL.equals(auth)) {
                    continue;
                }
                if (!authorities.contains(auth)) {
                    return false;
                }
            }
            return true;
        }
        if (type == TYPE_OR_GROUP) {
            for (AuthRule rule: orRules) {
                if (rule.isPermit(authorities)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

}
