package cn.zhxu.bp.auth;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * @author Troy.Zhou @ 2022/8/2 17:56
 */
@Getter
@Setter
@ToString
public class GrantInput {

    /** 所属平台 */
    private String domain;

    /** 请求地址 */
    @NotBlank
    @Pattern(regexp = "/[A-Za-z0-9_-]+/\\S*")
    private String path;

    /** 请求方法 */
    @NotBlank
    private String method;

    /** 访问令牌 */
    private String accessToken;

}
