package cn.zhxu.bp.auth;

import cn.zhxu.bp.utils.StringUtils;
import cn.zhxu.data.Mapper;
import cn.zhxu.bp.enums.ScopeType;
import lombok.Getter;

import java.util.*;

/**
 * 数据权限
 * @author Troy.Zhou @ 2022/8/23
 */
@Getter
public class Scope {

    /** 类型 */
    private final ScopeType type;

    /** 组 ID 列表 */
    private final String groupIds;

    public Scope(ScopeType type) {
        this(type, "-1");
    }

    public Scope(ScopeType type, List<Integer> groupIds) {
        this(type, StringUtils.join(groupIds.toArray(), ","));
    }

    public Scope(ScopeType type, String groupIds) {
        this.type = type;
        if (StringUtils.isBlank(groupIds)) {
            this.groupIds = "-1";
        } else {
            this.groupIds = groupIds;
        }
    }

    public List<Integer> groupIdList() {
        if (groupIds == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(groupIds.split(",")).map(Integer::parseInt).toList();
    }

    public boolean isEmptyGroup() {
        return StringUtils.isBlank(groupIds) || groupIds.trim().equals("-1");
    }

    static final String TYPE = "type";
    static final String GROUP_IDS = "groupIds";

    public static Scope parse(Mapper mapper) {
        if (mapper == null) {
            return null;
        }
        var type = ScopeType.from(mapper.getInt(TYPE));
        if (type == null) {
            return null;
        }
        var groupIds = mapper.getString(GROUP_IDS);
        return new Scope(type, groupIds);
    }

    public Map<String, Object> toMap() {
        var map = new HashMap<String, Object>();
        map.put(TYPE, type.value());
        map.put(GROUP_IDS, groupIds);
        return map;
    }

}
