package cn.zhxu.bp.enums;

/**
 * 模块类型
 * @author Troy.Zhou @ 2022/8/9 15:28
 */
public enum ModuleType {

    /**
     * 普通模块，不会自动开通，可卸载
     */
    COMMON,         // 0

    /**
     * 应用开通时会自动授于的模块，可卸载
     */
    AUTO_GRANT,     // 1

    /**
     * 强制模块，应用开通时会自动授于，不可卸载
     */
    MANDATORY,       // 2

    /**
     * 系统模块，超管系统专用，不能对平台开通
     */
    SYS              // 3

}
