package cn.zhxu.bp.enums;

/**
 * 数据权限类型
 * @author Troy.Zhou @ 2022/7/29 22:50
 */
public enum ScopeType {

    /**
     * 只查看自己的数据
     */
    ONLY_SELF(1),

    /**
     * 只查看自己与所在组的数据
     */
    SELF_GROUP(2),

    /**
     * 只查看自己与所在组以及子组的数据
     */
    SUB_GROUPS(3),

    /**
     * 可以查看所有数据
     */
    ALL(4);


    private final int value;

    ScopeType(int value) {
        this.value = value;
    }

    public int value() {
        return value;
    }

    public static ScopeType from(int value) {
        if (value == ONLY_SELF.value) {
            return ONLY_SELF;
        }
        if (value == SELF_GROUP.value) {
            return SELF_GROUP;
        }
        if (value == SUB_GROUPS.value) {
            return SUB_GROUPS;
        }
        if (value == ALL.value) {
            return ALL;
        }
        return null;
    }

}
