package cn.zhxu.bp.enums;

import cn.zhxu.bp.model.*;
import java.util.regex.Pattern;

/**
 * @author Troy.Zhou @ 2022/8/3 16:49
 */
public interface SysConst {

    int SYS_SAAS_ID = 0;

    /**
     * 请求头
     */
    interface Header {

        String TOKEN = "X-Token";
        String DOMAIN = "X-Domain";
        String CLIENT = "X-Client";
        String PRINCIPAL = "X-Principal";
        String LOG_TEXT = "X-LogText";
        String LogUser = "X-LogUser";
        String APP_ID = "X-AppID";

    }

    interface AppWidget {
        String DEFAULT_NAME = "Default";
        String DEFAULT_KEY = "default";
    }

    Pattern ID_LIST_PATTERN = Pattern.compile("\\[[0-9,]*]");

    Pattern ID_MAP_PATTERN = Pattern.compile("\\{[0-9\":,]*}");

    String EMPTY_LIST = "[]";

    String EMPTY_OBJECT = "{}";

    String CLIENT_TYPE__BROWSER = "Browser";

    interface AppKeys {

        String SYS = "sys";
        String SAPI = "sapi";

    }

    interface DictKeys {

        String SMS_APP_KEY = "smsAppId";

        String SMS_TMPL_ID = "smsTmplId_";

        static String smsTmplName(String name) {
            return SMS_TMPL_ID + name;
        }

    }

    /**
     * 用户来源
     */
    interface UserSource {

        /**
         * 自己注册
         */
        String REGISTER = "register";

        /**
         * 在控制台创建
         */
        String CONSOLE = "console";

        /**
         * 子应用 API 调用
         */
        String API = "api";

    }

    int DEFAULT_GROUP_ID = 0;

    String DEFAULT_GROUP_NAME = "总公司";

    /**
     * 事件推荐接口
     */
    String PUSH_URL = "/bp/events";

    String PUSH_SUCCESS_RETURN = "success";

    interface PushEvt {

        /** 用户自主注册
         * @see UserMsg
         * */
        String ACCOUNT_USER_REGISTER = "ACCOUNT_USER_REGISTER";

        /** 用户自己更新信息
         * @see UserInfo
         * */
        String ACCOUNT_USER_UPDATE = "ACCOUNT_USER_UPDATE";

        /** 用户自己修改密码
         * @see UserPwd
         * */
        String ACCOUNT_USER_MOD_PWD = "ACCOUNT_USER_MOD_PWD";

        /** 后台创建账号
         * @see UserMsg */
        String ACCOUNT_CONSOLE_CREATE = "ACCOUNT_CONSOLE_CREATE";

        /** 后台更新账号
         * @see UserMsg */
        String ACCOUNT_CONSOLE_UPDATE = "ACCOUNT_CONSOLE_UPDATE";

        /** 后台更新账号过期时间
         * @see UserExp */
        String ACCOUNT_CONSOLE_EXPIRE = "ACCOUNT_CONSOLE_EXPIRE";

        /** 后台删除账号
         * @see UserNo */
        String ACCOUNT_CONSOLE_DELETE = "ACCOUNT_CONSOLE_DELETE";

        /** 后台修改用户密码
         * @see UserPwd
         * */
        String ACCOUNT_CONSOLE_MOD_PWD = "ACCOUNT_CONSOLE_MOD_PWD";

        /** API 创建账号
         * @see UserMsg */
        String ACCOUNT_API_CREATE = "ACCOUNT_API_CREATE";

        /** API 更新账号
         * @see UserMsg */
        String ACCOUNT_API_UPDATE = "ACCOUNT_API_UPDATE";

        /** 创建顶级账号
         * @see UserAdm */
        String SYSTEM_ADMIN_CREATE = "SYSTEM_ADMIN_CREATE";

        /** 更新顶级账号
         * @see UserAdm */
        String SYSTEM_ADMIN_UPDATE = "SYSTEM_ADMIN_UPDATE";

        /** 重置顶级账号密码
         * @see UserPwd */
        String SYSTEM_ADMIN_MOD_PW = "SYSTEM_ADMIN_MOD_PW";

        /** 创建 SaaS 平台
         * @see SaasMsg */
        String SYSTEM_SAAS_CREATE = "SYSTEM_SAAS_CREATE";

        /** 更新 SaaS 平台
         * @see SaasMsg */
        String SYSTEM_SAAS_UPDATE = "SYSTEM_SAAS_UPDATE";

        /** 删除 SaaS 平台
         * @see SaasId */
        String SYSTEM_SAAS_DELETE = "SYSTEM_SAAS_DELETE";

        /** SaaS 平台开通应用
         * @see SaInfo */
        String SYSTEM_SAAS_APP_CREATE = "SYSTEM_SAAS_APP_CREATE";

        /** SaaS 平台更新应用
         * @see SaInfo */
        String SYSTEM_SAAS_APP_UPDATE = "SYSTEM_SAAS_APP_UPDATE";

        /** SaaS 平台卸载应用
         * @see SaInfo */
        String SYSTEM_SAAS_APP_DELETE = "SYSTEM_SAAS_APP_DELETE";

        /** 平台的字典配置更新
         * @see SaDict */
        String SYSTEM_SAAS_DICT_UPDATE = "SYSTEM_SAAS_DICT_UPDATE";

    }

    interface RedisKey {

        /**
         * 消息队列：推送事件
         */
        String MQ_EVENTS = "mq:events";

        /**
         * 消息队列：用户日志
         */
        String MQ_USER_LOG = "mq:logs";

        /**
         * 系统最近 1小时的活跃用户 ID 集合（每 1 小时同步至数据库并清空）
         */
        String ACTIVE_USER_SET = "count:activeSet";

        /**
         * 用户最后活跃时间（每 1 小时同步至数据库，2 小时过期）
         */
        String USER_LAST_ACTIVE = "user:lastActive:";

        /**
         * 平台当天的所有活跃用户（次日凌晨同步至数据库并清空）
         */
        String SAAS_ACTIVE_USER_SET = "count:activeSet:saas-";

        /**
         * 平台当天的登录次数统计（次日凌晨同步至数据库并清空）
         */
        String SAAS_LOGIN_COUNT = "count:login-cnt:saas-";

        /**
         * 平台应用当天的访问次数统计（次日凌晨同步至数据库并清空）
         */
        String SAAS_APP_VISIT_COUNT = "count:saasApp-";

        /**
         * 应用当天的响应 1xx 的次数统计（次日凌晨同步至数据库并清空）
         */
        String APP_1XX_COUNT = "count:app1xx-";

        /**
         * 应用当天的响应 2xx 的次数统计（次日凌晨同步至数据库并清空）
         */
        String APP_2XX_COUNT = "count:app2xx-";

        /**
         * 应用当天的响应 3xx 的次数统计（次日凌晨同步至数据库并清空）
         */
        String APP_3XX_COUNT = "count:app3xx-";

        /**
         * 应用当天的响应 4xx 的次数统计（次日凌晨同步至数据库并清空）
         */
        String APP_4XX_COUNT = "count:app4xx-";

        /**
         * 应用当天的响应 5xx 的次数统计（次日凌晨同步至数据库并清空）
         */
        String APP_5XX_COUNT = "count:app5xx-";

    }

}
