package cn.zhxu.bp.enums;

/**
 * 用户属性键值
 * @author Troy.Zhou @ 2022/8/3 12:17
 */
public interface UserAttrs {

    /**
     * 系统最高权限账号
     * 只有系统账号 {@link UserType#SYS } 才能成为 系统最高权限账号
     * 系统最高权限账号能登录 超管后台，且自动用户 超管后台 的所有权限
     */
    String SYS_GOD = "sysGod";

    /**
     * 上帝账号，只有系统账号 {@link UserType#SYS } 才能成为 上帝账号
     * 上帝账号可登录所有的 SAAS 平台，权限等同于 SAAS 平台 的顶级账号 {@link UserType#TOP }
     */
    String SUB_GOD = "subGod";

    /**
     * 真实姓名
     */
    String REAL_NAME = "realName";

    /**
     * 地址
     */
    String ADDRESS = "address";

    /**
     * 有效期（yyyy-MM-dd）
     */
    String EXPIRE_AT = "expireAt";

    /**
     * 用户来源
     */
    String SOURCE = "source";

    /**
     * 备注
     */
    String REMARK = "remark";

}
