package cn.zhxu.bp.enums;

import cn.zhxu.bp.RespException;

/**
 * 用户类型
 * @author Troy.Zhou @ 2022/10/11
 */
public enum UserType {

    SYS(1, "系统账号"),
    TOP(2, "顶级账号"),
    ADM(3, "管理账号");

    private final int value;
    private final String name;

    UserType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static UserType of(int uType) {
        if (uType == SYS.value) {
            return SYS;
        }
        if (uType == TOP.value) {
            return TOP;
        }
        if (uType == ADM.value) {
            return ADM;
        }
        throw RespException.forbidden("No such UserType: " + uType);
    }

}
