package cn.zhxu.bp.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class MapUtils {

    public static Map<String, Object> newFrom(Object source) {
        if (source == null) {
            return null;
        }
        Map<String, Object> map = new HashMap<>();
        Class<?> clazz = source.getClass();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    map.put(field.getName(), field.get(source));
                } catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return map;
    }

}
