package cn.zhxu.bp.enums;

/**
 * 应用类型
 * @author Troy.Zhou @ 2022/8/5 15:04
 */
public enum AppType {

    /**
     * 超级管理系统
     */
    SYSTEM,         // 0

    /**
     * 超管系统的子应用（非 SAAS 应用）
     */
    SYS_APP,        // 1

    /**
     * 超管系统的功能集（非 SAAS 应用）
     */
    SYS_FUNC,       // 2

    /**
     * 超管系统 与 SAAS 平台 都拥有的 APP
     */
    COMM_APP,       // 3

    /**
     * 基础功能集（创建 SAAS 平台后会自动开通）
     * 超管系统 与 SAAS 平台 都可使用
     */
    COMM_FUNC,      // 4

    /**
     * SAAS 平台应用（创建 SAAS 平台后，需要手动开通）
     */
    SAAS_APP,       // 5

    /**
     * SAAS 平台功能集（创建 SAAS 平台后，需要手动开通）
     */
    SAAS_FUNC,      // 6

}
