package cn.zhxu.bp.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.Min;

@Getter
@Setter
@ToString
public class GatewayAttrs {

    /**
     * 全局限流参数：令牌桶每秒新增的速率
     */
    @Min(1)
    private Integer globalRate;

    /**
     * 全局限流参数：令牌桶最大容量
     */
    @Min(1)
    private Integer globalTotal;

    /**
     * User/IP 限流参数：令牌桶每秒新增的速率
     */
    @Min(1)
    private Integer userRate;

    /**
     * User/IP 限流参数：令牌桶最大容量
     */
    @Min(1)
    private Integer userTotal;

    /**
     * 转发最大重试次数
     */
    @Min(0)
    private Integer retries;

}
