package cn.zhxu.bp.model;


import cn.zhxu.bp.enums.SysConst;
import lombok.Getter;
import lombok.Setter;

/**
 * 推送消息
 * @author Troy.Zhou @ 2022/11/15
 * 适用于以下事件
 * @see SysConst.PushEvt#SYSTEM_SAAS_CREATE
 * @see SysConst.PushEvt#SYSTEM_SAAS_UPDATE
 */
@Getter
@Setter
public class SaasMsg {

    /**
     * 平台 ID
     */
    private int id;

    /**
     * 平台名称
     */
    private String name;

    /**
     * 公司名
     */
    private String company;

    /**
     * 个性域名,只能包含字母、数字、中划线
     */
    private String domain;

    /**
     * 安全手机号，用于平台机密设置验证
     */
    private String phone;

    /**
     * 平台 LOGO
     *
     */
    private String logo;

    /**
     * 备注描述
     */
    private String description;

}
